<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Show a notice on profile.
 */
function um_profile_completeness_show_notice() {
	wp_enqueue_script( 'um_profile_completeness' );
	wp_enqueue_style( 'um_profile_completeness' );

	// phpcs:disable WordPress.Security.NonceVerification
	if ( ! isset( $_GET['notice'] ) ) {
		return;
	}

	$type   = 'warning';
	$notice = sanitize_key( $_GET['notice'] );
	switch ( $notice ) {
		case 'incomplete_access':
		case 'incomplete_view':
			$message = __( 'You need to complete your profile before you can view that page.', 'um-profile-completeness' );
			$type    = 'error';
			break;
		case 'incomplete_comment':
			$message = __( 'You need to complete your profile before you can leave comments.', 'um-profile-completeness' );
			break;
		case 'incomplete_forum':
			$message = __( 'You need to complete your profile before you can participate in forums.', 'um-profile-completeness' );
			break;
	}

	if ( isset( $message ) ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			$alert = UM()->frontend()::layouts()::alert( $message, array( 'type' => $type ) );
			echo wp_kses( $alert, UM()->get_allowed_html( 'templates' ) );
		} else {
			echo '<p class="um-notice warning" style="margin: 0 0 12px 0 !important;">' . wp_kses( $message, UM()->get_allowed_html( 'templates' ) ) . '</p>';
		}
	}
}
add_action( 'um_profile_before_header', 'um_profile_completeness_show_notice' );

/**
 * Maybe redirect user if profile completed and redirect isset.
 *
 * @param int $user_id
 */
function my_after_user_updated( $user_id ) {
	$role_data = UM()->roles()->role_data( UM()->roles()->get_priority_user_role( $user_id ) );
	if ( ! empty( $role_data['profilec_redirect_enable'] ) && ! empty( $role_data['profilec_redirect'] ) ) {
		$progress_data = UM()->Profile_Completeness_API()->get_progress( $user_id );
		if ( -1 === $progress_data ) {
			return;
		}

		$profile_progress = $progress_data['progress'];
		$profile_required = $progress_data['req_progress'];
		if ( (int) $profile_progress >= (int) $profile_required ) {
			$url = $role_data['profilec_redirect'];
			um_safe_redirect( esc_url_raw( $url ) );
		}
	}
}
add_action( 'um_after_user_updated', 'my_after_user_updated' );
