<?php
/**
 * Template for the UM Real-time Notifications Button
 *
 * Called from the Notifications_Shortcode->ultimatemember_notifications_button() method
 * @version 2.3.2
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-notifications/notifications_button.php
 * @var string $notify_pos
 * @var string $new_notifications_formatted
 * @var string $show_always
 * @var int    $new_notifications
 * @var bool   $static
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} ?>

<div class="um-notification-b <?php echo esc_attr( $notify_pos ); ?>" data-show-always="<?php echo esc_attr( $show_always ); ?>"<?php echo empty( $static ) ? '' : ' style="position:static;"'; ?>>
	<i class="um-icon-ios-bell"></i>
	<span class="um-notification-live-count count-<?php echo esc_attr( $new_notifications ); ?>">
		<?php echo esc_html( $new_notifications_formatted ); ?>
	</span>
</div>
