<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class UM_Notifications_API {

	/**
	 * For backward compatibility with 1.3.x and PHP8.2 compatibility.
	 *
	 * @var bool
	 */
	public $plugin_inactive = false;

	/**
	 * @var
	 */
	private static $instance;

	/**
	 * @return UM_Notifications_API
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * UM_Notifications_API constructor.
	 */
	public function __construct() {
		// Global for backwards compatibility.
		$GLOBALS['um_notifications'] = $this;
		add_filter( 'um_call_object_Notifications_API', array( &$this, 'get_this' ) );
		add_filter( 'um_settings_default_values', array( &$this, 'default_settings' ), 10, 1 );

		$this->enqueue();
		$this->shortcode();

		add_action( 'plugins_loaded', array( &$this, 'init' ), 0 );

		add_filter( 'um_core_pages', array( &$this, 'um_notification_core_page' ) );
		add_filter( 'um_setup_predefined_page_content', array( &$this, 'predefined_pages_content' ), 10, 2 );

		add_filter( 'um_rest_api_get_stats', array( &$this, 'rest_api_get_stats' ), 10, 1 );

		add_action( 'wp_ajax_um_notification_delete_log', array( $this->api(), 'ajax_delete_log' ) );
		add_action( 'wp_ajax_um_notification_delete_all_log', array( $this->api(), 'ajax_delete_all_log' ) );
		add_action( 'wp_ajax_um_notification_mark_as_read', array( $this->api(), 'ajax_mark_as_read' ) );
		add_action( 'wp_ajax_um_notification_mark_all_as_read', array( $this->api(), 'ajax_mark_all_as_read' ) );
		add_action( 'wp_ajax_um_notification_change_notifications_prefs', array( $this->api(), 'ajax_change_notifications_prefs' ) );

		add_action( 'wp_ajax_um_notification_check_update', array( $this->api(), 'ajax_check_update' ) );
		add_action( 'wp_ajax_um_get_on_load_notification', array( $this->api(), 'ajax_on_load_notification' ) );
		add_action( 'wp_ajax_um_notification_get_new_count', array( $this->api(), 'ajax_get_new_count' ) );
	}

	/**
	 * @return $this
	 */
	public function get_this() {
		return $this;
	}

	/**
	 * @param $defaults
	 *
	 * @return array
	 */
	public function default_settings( $defaults ) {
		$defaults = array_merge( $defaults, $this->setup()->settings_defaults );
		return $defaults;
	}

	/**
	 * @param $response
	 *
	 * @return mixed
	 */
	public function rest_api_get_stats( $response ) {
		global $wpdb;

		$total_notifications = absint( $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}um_notifications" ) );

		$response['stats']['total_notifications'] = $total_notifications;
		return $response;
	}

	/**
	 * @return um_ext\um_notifications\core\Notifications_Setup()
	 */
	public function setup() {
		if ( empty( UM()->classes['um_notifications_setup'] ) ) {
			UM()->classes['um_notifications_setup'] = new um_ext\um_notifications\core\Notifications_Setup();
		}
		return UM()->classes['um_notifications_setup'];
	}

	/**
	 * Extend core pages.
	 *
	 * @param array $pages
	 *
	 * @return array
	 */
	public function um_notification_core_page( $pages ) {
		$pages['notifications'] = array( 'title' => __( 'Notifications', 'um-notifications' ) );
		return $pages;
	}

	/**
	 * Predefined pages content.
	 *
	 * @param string $content Predefined page content.
	 * @param string $slug    Predefined page slug (key).
	 *
	 * @since 1.0.0
	 * @return string Predefined page content.
	 */
	public function predefined_pages_content( $content, $slug ) {
		if ( 'notifications' === $slug ) {
			$content = '[ultimatemember_notifications]';
		}

		return $content;
	}

	/**
	 * @return um_ext\um_notifications\core\Notifications_Main_API()
	 */
	public function api() {
		if ( empty( UM()->classes['um_notifications_api'] ) ) {
			UM()->classes['um_notifications_api'] = new um_ext\um_notifications\core\Notifications_Main_API();
		}
		return UM()->classes['um_notifications_api'];
	}

	/**
	 * @return um_ext\um_notifications\core\Notifications_Enqueue()
	 */
	public function enqueue() {
		if ( empty( UM()->classes['um_notification_enqueue'] ) ) {
			UM()->classes['um_notification_enqueue'] = new um_ext\um_notifications\core\Notifications_Enqueue();
		}
		return UM()->classes['um_notification_enqueue'];
	}

	/**
	 * @return um_ext\um_notifications\core\Notifications_Shortcode()
	 */
	public function shortcode() {
		if ( empty( UM()->classes['um_notification_shortcode'] ) ) {
			UM()->classes['um_notification_shortcode'] = new um_ext\um_notifications\core\Notifications_Shortcode();
		}
		return UM()->classes['um_notification_shortcode'];
	}

	/**
	 * Init
	 */
	public function init() {
		// Actions
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-comment.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-review.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-mycred.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-profile.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-bbpress.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-log-user.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-footer.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-account.php';
		require_once um_notifications_path . 'includes/core/actions/um-notifications-hooks.php';

		// Filters
		require_once um_notifications_path . 'includes/core/filters/um-notifications-settings.php';
		require_once um_notifications_path . 'includes/core/filters/um-notifications-license.php';
		require_once um_notifications_path . 'includes/core/filters/um-notifications-account.php';
	}
}

//create class var
add_action( 'plugins_loaded', 'um_init_notifications', -10, 1 );
function um_init_notifications() {
	if ( function_exists( 'UM' ) ) {
		UM()->set_class( 'Notifications_API', true );
	}
}
