<?php
/**
 * Template for the UM Notices
 * Shown in the footer
 * Called from the Notices_Query->show_notice() method
 * @version 2.1.2
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-notices/notice.php
 * @var int|null $force_id
 * @var string   $close_color
 * @var string   $icon_color
 * @var int      $notice_id
 * @var object   $notice
 * @var string   $style
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!-- um-notices/templates/notice.php -->
<div class="um-icon-within um-notices-wrap <?php echo ( $force_id ) ? 'yes-shortcode' : 'no-shortcode'; ?> um-notices-<?php echo esc_attr( UM()->options()->get( 'notice_pos' ) ); ?>" style="<?php echo esc_attr( $style ); ?>" data-notice_id="<?php echo esc_attr( $notice_id ); ?>">
	<div class="um-notices-box <?php echo empty( $meta['_um_icon'][0] ) ? '' : 'has-icon'; ?>">
		<a href="javascript:void(0);" class="um-notices-close" style="<?php echo esc_attr( $close_color ); ?>">
			<i class="fas fa-xmark"></i>
		</a>

		<?php if ( ! empty( $meta['_um_icon'][0] ) ) { ?>
			<i class="<?php echo esc_attr( $meta['_um_icon'][0] ); ?>" style="<?php echo esc_attr( $icon_color ); ?>"></i>
			<?php
		}

		setup_postdata( $notice );
		the_content();
		wp_reset_postdata();

		if ( ! empty( $meta['_um_cta'][0] ) ) {
			$cta_bg    = ! empty( $meta['_um_cta_bg'][0] ) ? $meta['_um_cta_bg'][0] : '#666';
			$cta_color = ! empty( $meta['_um_cta_clr'][0] ) ? $meta['_um_cta_clr'][0] : '#fff';
			?>
			<div class="um-notices-cta">
				<a href="<?php echo esc_url( $meta['_um_cta_url'][0] ); ?>" style="background:<?php echo esc_attr( $cta_bg ); ?>;color:<?php echo esc_attr( $cta_color ); ?>;">
					<?php echo esc_html( $meta['_um_cta_text'][0] ); ?>
				</a>
			</div>
		<?php } ?>
	</div>
</div>

<?php if ( ! empty( $meta['_um_textcolor'][0] ) || ! empty( $meta['_um_min_width'][0] ) ) { ?>
	<style>
		<?php if ( ! empty( $meta['_um_textcolor'][0] ) ) { ?>
			.um-notices-wrap[data-notice_id="<?php echo esc_attr( $notice_id ); ?>"] p {
				color: <?php echo esc_attr( $meta['_um_textcolor'][0] ); ?> !important;
			}
			.um-notices-wrap[data-notice_id="<?php echo esc_attr( $notice_id ); ?>"] p a {
				color: <?php echo esc_attr( $meta['_um_textcolor'][0] ); ?> !important;
				text-decoration: underline !important;
			}
		<?php } ?>
		<?php if ( ! empty( $meta['_um_min_width'][0] ) ) { ?>
			.um-notices-wrap[data-notice_id="<?php echo esc_attr( $notice_id ); ?>"].no-shortcode {
				min-width: <?php echo esc_attr( $meta['_um_min_width'][0] ); ?>;
			}
		<?php } ?>
	</style>
	<?php
}
