<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class UM_Notices
 */
class UM_Notices {

	/**
	 * For backward compatibility with 1.3.x and PHP8.2 compatibility.
	 *
	 * @var bool
	 */
	public $plugin_inactive = false;

	/**
	 * @var
	 */
	public $shortcodes = array();

	/**
	 * @var
	 */
	private static $instance;

	/**
	 * @return UM_Notices
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * UM_Notices constructor.
	 */
	public function __construct() {
		// Global for backwards compatibility.
		$GLOBALS['um_notices'] = $this;
		add_filter( 'um_call_object_Notices_API', array( &$this, 'get_this' ) );

		$this->query();

		if ( UM()->is_request( 'admin' ) ) {
			$this->admin_enqueue();
			$this->site_health();
			$this->admin();
			$this->metabox();
			$this->admin_upgrade();
		}

		if ( UM()->is_request( 'frontend' ) ) {
			$this->enqueue();
			$this->shortcode();
		}

		add_action( 'init', array( &$this, 'create_cpt' ), 2 );
		add_filter( 'um_cpt_list', array( &$this, 'add_cpt' ) );
		add_action( 'plugins_loaded', array( &$this, 'init' ), 0 );

		add_filter( 'um_settings_default_values', array( &$this, 'default_settings' ) );

		add_action( 'um_delete_user', array( $this, 'clear_notices' ) );
		add_action( 'wp_ajax_um_notices_mark_seen', array( $this, 'ajax_mark_notice_seen' ) );
		add_action( 'wp_ajax_nopriv_um_notices_mark_seen', array( $this, 'ajax_mark_notice_seen' ) );
	}

	/**
	 * @param int $user_id
	 */
	public function clear_notices( $user_id ) {
		$posts = get_posts(
			array(
				'post_type'      => 'um_notice',
				'posts_per_page' => -1,
				'fields'         => 'ids',
			)
		);

		foreach ( $posts as $post_id ) {
			$users = get_post_meta( $post_id, '_users', true );
			if ( empty( $users ) || ! is_array( $users ) ) {
				continue;
			}

			$users_map = array_map( 'absint', $users );
			if ( in_array( $user_id, $users_map, true ) ) {
				$user_key = array_search( $user_id, $users_map, true );
				unset( $users[ $user_key ] );
				update_post_meta( $post_id, '_users', $users );
			}
		}
	}

	/**
	 * @param array $defaults
	 *
	 * @return array
	 */
	public function default_settings( $defaults ) {
		return array_merge( $defaults, $this->setup()->settings_defaults );
	}

	/**
	 * @return $this
	 */
	public function get_this() {
		return $this;
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Setup
	 */
	public function setup() {
		if ( empty( UM()->classes['um_notices_setup'] ) ) {
			UM()->classes['um_notices_setup'] = new um_ext\um_notices\core\Notices_Setup();
		}
		return UM()->classes['um_notices_setup'];
	}

	/**
	 *
	 */
	public function ajax_mark_notice_seen() {
		UM()->check_ajax_nonce();

		// phpcs:disable WordPress.Security.NonceVerification
		if ( empty( $_REQUEST['notice_id'] ) ) {
			wp_send_json_error();
		}
		$notice_id = absint( $_REQUEST['notice_id'] );
		if ( empty( $notice_id ) ) {
			wp_send_json_error();
		}
		// phpcs:enable WordPress.Security.NonceVerification

		$notice = get_post( $notice_id );
		if ( empty( $notice ) ) {
			wp_send_json_error();
		}

		$for_loggedout = get_post_meta( $notice_id, '_um_show_loggedout', true );
		if ( empty( $for_loggedout ) && ! is_user_logged_in() ) {
			wp_send_json_error();
		}

		$for_loggedin = get_post_meta( $notice_id, '_um_show_loggedin', true );
		if ( empty( $for_loggedin ) && is_user_logged_in() ) {
			wp_send_json_error();
		}

		if ( is_user_logged_in() ) {
			$for_loggedin_roles = get_post_meta( $notice_id, '_um_roles', true );
			if ( ! empty( $for_loggedin_roles ) ) {
				$current_user_roles = UM()->roles()->get_all_user_roles( get_current_user_id() );
				if ( empty( $current_user_roles ) || count( array_intersect( $current_user_roles, $for_loggedin_roles ) ) <= 0 ) {
					wp_send_json_error();
				}
			}

			$user_id = get_current_user_id();

			$users = get_post_meta( $notice_id, '_users', true );
			if ( ! is_array( $users ) ) {
				$users = array();
			}

			$users[] = $user_id;
			update_post_meta( $notice_id, '_users', $users );
		}

		// register this notice in a cookie anyway
		setcookie( 'um_notice_seen_' . $notice_id, true, time() + ( 86400 * 7 ), '/' );

		wp_send_json_success();
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Admin
	 */
	public function admin() {
		if ( empty( UM()->classes['um_notices_admin'] ) ) {
			UM()->classes['um_notices_admin'] = new um_ext\um_notices\core\Notices_Admin();
		}
		return UM()->classes['um_notices_admin'];
	}

	/**
	 * @return um_ext\um_notices\admin\Enqueue
	 */
	public function admin_enqueue() {
		if ( empty( UM()->classes['um_notices_admin_enqueue'] ) ) {
			UM()->classes['um_notices_admin_enqueue'] = new um_ext\um_notices\admin\Enqueue();
		}
		return UM()->classes['um_notices_admin_enqueue'];
	}

	/**
	 * @return um_ext\um_notices\admin\Site_Health
	 */
	public function site_health() {
		if ( empty( UM()->classes['um_notices_admin_site_health'] ) ) {
			UM()->classes['um_notices_admin_site_health'] = new um_ext\um_notices\admin\Site_Health();
		}
		return UM()->classes['um_notices_admin_site_health'];
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Enqueue
	 */
	public function enqueue() {
		if ( empty( UM()->classes['um_notices_enqueue'] ) ) {
			UM()->classes['um_notices_enqueue'] = new um_ext\um_notices\core\Notices_Enqueue();
		}
		return UM()->classes['um_notices_enqueue'];
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Metabox
	 */
	public function metabox() {
		if ( empty( UM()->classes['um_notices_metabox'] ) ) {
			UM()->classes['um_notices_metabox'] = new um_ext\um_notices\core\Notices_Metabox();
		}
		return UM()->classes['um_notices_metabox'];
	}

	/**
	 * @return um_ext\um_notices\admin\core\Admin_Upgrade
	 */
	public function admin_upgrade() {
		if ( empty( UM()->classes['um_notices_admin_upgrade'] ) ) {
			UM()->classes['um_notices_admin_upgrade'] = new um_ext\um_notices\admin\core\Admin_Upgrade();
		}
		return UM()->classes['um_notices_admin_upgrade'];
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Shortcode
	 */
	public function shortcode() {
		if ( empty( UM()->classes['um_notices_shortcode'] ) ) {
			UM()->classes['um_notices_shortcode'] = new um_ext\um_notices\core\Notices_Shortcode();
		}
		return UM()->classes['um_notices_shortcode'];
	}

	/**
	 * @return um_ext\um_notices\core\Notices_Query
	 */
	public function query() {
		if ( empty( UM()->classes['um_notices_query'] ) ) {
			UM()->classes['um_notices_query'] = new um_ext\um_notices\core\Notices_Query();
		}
		return UM()->classes['um_notices_query'];
	}

	/**
	 * Init
	 */
	public function init() {
		require_once um_notices_path . 'includes/core/filters/um-notices-license.php';
		require_once um_notices_path . 'includes/core/filters/um-notices-settings.php';
	}

	/**
	 * creates needed cpt
	 */
	public function create_cpt() {
		register_post_type(
			'um_notice',
			array(
				'labels'          => array(
					'name'               => __( 'Notices', 'um-notices' ),
					'singular_name'      => __( 'Notice', 'um-notices' ),
					'add_new'            => __( 'Add New Notice', 'um-notices' ),
					'add_new_item'       => __( 'Add New Notice', 'um-notices' ),
					'edit_item'          => __( 'Edit Notice', 'um-notices' ),
					'not_found'          => __( 'You did not create any notices yet', 'um-notices' ),
					'not_found_in_trash' => __( 'Nothing found in Trash', 'um-notices' ),
					'search_items'       => __( 'Search Notices', 'um-notices' ),
				),
				'show_ui'         => true,
				'show_in_menu'    => false,
				'public'          => false,
				'supports'        => array( 'title', 'editor' ),
				'capability_type' => 'page',
			)
		);
	}

	/**
	 * @param array $um_cpt
	 *
	 * @return array
	 */
	public function add_cpt( $um_cpt ) {
		$um_cpt[] = 'um_notice';
		return $um_cpt;
	}
}

//create class var
add_action( 'plugins_loaded', 'um_init_notices', -10 );
function um_init_notices() {
	if ( function_exists( 'UM' ) ) {
		UM()->set_class( 'Notices', true );
	}
}
