<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Extend settings
 *
 * @param $settings
 *
 * @return mixed
 */
function um_notices_settings( $settings ) {
	$settings['extensions']['sections']['notices'] = array(
		'title'  => __( 'Notices', 'um-notices' ),
		'fields' => array(
			array(
				'id'          => 'notice_pos',
				'type'        => 'select',
				'label'       => __( 'Notice Position in Footer', 'um-notices' ),
				'options'     => array(
					'right' => __( 'Show to Right', 'um-notices' ),
					'left'  => __( 'Show to Left', 'um-notices' ),
				),
				'placeholder' => __( 'Select...', 'um-notices' ),
				'size'        => 'middle',
			),
		),
	);

	return $settings;
}
add_filter( 'um_settings_structure', 'um_notices_settings', 10, 1 );

/**
 * Scan templates from extension
 *
 * @param $scan_files
 *
 * @return array
 */
function um_notices_extend_scan_files( $scan_files ) {
	$extension_files['um-notices'] = UM()->admin_settings()->scan_template_files( um_notices_path . '/templates/' );
	$scan_files                    = array_merge( $scan_files, $extension_files );

	return $scan_files;
}
add_filter( 'um_override_templates_scan_files', 'um_notices_extend_scan_files', 10, 1 );

/**
 * Get template paths
 *
 * @param $located
 * @param $file
 *
 * @return array
 */
function um_notices_get_path_template( $located, $file ) {
	if ( file_exists( get_stylesheet_directory() . '/ultimate-member/um-notices/' . $file ) ) {
		$located = array(
			'theme' => get_stylesheet_directory() . '/ultimate-member/um-notices/' . $file,
			'core'  => um_notices_path . 'templates/' . $file,
		);
	}

	return $located;
}
add_filter( 'um_override_templates_get_template_path__um-notices', 'um_notices_get_path_template', 10, 2 );
