<?php
namespace um_ext\um_notices\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Notices_Query
 * @package um_ext\um_notices\core
 */
class Notices_Query {

	/**
	 * @var null|int
	 */
	public $notice_id;

	/**
	 * Notices_Query constructor.
	 */
	public function __construct() {
		if ( ! is_admin() ) {
			add_action( 'wp_footer', array( &$this, 'head_enqueue' ), -1 );
			add_action( 'wp_footer', array( &$this, 'show_notice' ), 9999 );
		}
	}

	/**
	 *
	 */
	public function head_enqueue() {
		$this->get_notices();

		if ( ! isset( $this->notice_id ) || $this->notice_id <= 0 ) {
			return;
		}

		wp_enqueue_script( 'um_notices' );
		wp_enqueue_style( 'um_notices' );
	}

	/**
	 * Display notices in footer
	 *
	 * @param null $force_id
	 */
	public function show_notice( $force_id = null ) {
		$this->get_notices( $force_id );

		if ( ! isset( $this->notice_id ) || $this->notice_id <= 0 ) {
			return;
		}

		$notice_id = $this->notice_id;

		$notice = get_post( $notice_id );
		$meta   = get_post_custom( $notice_id );

		$style = '';
		if ( $notice->_um_border ) {
			$style .= ' border: ' . $notice->_um_border . ';border-bottom: none !important;';
		}
		if ( $notice->_um_border_radius ) {
			$style .= ' border-radius: ' . $notice->_um_border_radius . ' ' . $notice->_um_border_radius . ' 0px 0px;';
		}
		if ( $notice->_um_boxshadow ) {
			$style .= ' box-shadow: ' . $notice->_um_boxshadow . ';';
		}
		if ( $notice->_um_bgcolor ) {
			$style .= ' background: ' . $notice->_um_bgcolor . ';';
		}
		if ( $notice->_um_textcolor ) {
			$style .= ' color: ' . $notice->_um_textcolor . ';';
		}
		if ( $notice->_um_fontsize ) {
			$style .= ' font-size: ' . $notice->_um_fontsize . ';';
		}

		$close_color = '';
		if ( $notice->_um_closeiconcolor ) {
			$close_color = ' color: ' . $notice->_um_closeiconcolor . ';';
		} elseif ( $notice->_um_textcolor ) {
			$close_color = ' color: ' . $notice->_um_textcolor . ';';
		}

		$icon_color = '';
		if ( $notice->_um_iconcolor ) {
			$icon_color = ' color: ' . $notice->_um_iconcolor . ';';
		} elseif ( $notice->_um_textcolor ) {
			$icon_color = ' color: ' . $notice->_um_textcolor . ';';
		}

		wp_reset_query();

		global $post;

		$temp_global = $post;

		wp_enqueue_script( 'um_notices' );
		wp_enqueue_style( 'um_notices' );

		$post = $notice;

		$t_args = compact( 'close_color', 'force_id', 'icon_color', 'meta', 'notice_id', 'notice', 'style' );
		UM()->get_template( 'notice.php', um_notices_plugin, $t_args, true );

		$post = $temp_global;
	}

	/**
	 * Get user notices
	 *
	 * @param int|null $force_id
	 */
	public function get_notices( $force_id = null ) {
		global $current_user;

		$args = array(
			'post_status'    => array( 'publish' ),
			'post_type'      => 'um_notice',
			'posts_per_page' => -1,
			'fields'         => 'ids',
		);

		if ( $force_id ) {
			$args['post__in'] = array( $force_id );
		}

		$notices       = new \WP_Query( $args );
		$notices_count = $notices->found_posts;
		if ( $notices_count <= 0 ) {
			return;
		}

		$user_notices = $notices->posts;
		foreach ( $user_notices as $k => $notice_id ) {

			$meta = get_post_custom( $notice_id );

			if ( ! $force_id ) {

				if ( isset( UM()->Notices()->shortcodes[ $notice_id ] ) ) {
					unset( $user_notices[ $k ] );
				}

				if ( empty( $meta['_um_show_in_footer'][0] ) ) {
					unset( $user_notices[ $k ] );
				}

				if ( empty( $meta['_um_show_everywhere'][0] ) ) {
					$current_url       = UM()->permalinks()->get_current_url( true );
					$current_url       = untrailingslashit( $current_url );
					$current_url_slash = trailingslashit( $current_url );

					if ( ! empty( $meta['_um_show_in_urls'][0] ) ) {
						if ( empty( $meta['_um_allowed_urls'][0] ) ) {
							unset( $user_notices[ $k ] );
						}

						$urls = array_map( 'rtrim', explode( "\n", $meta['_um_allowed_urls'][0] ) );
						if ( ! ( in_array( $current_url, $urls, true ) || in_array( $current_url_slash, $urls, true ) ) ) {
							unset( $user_notices[ $k ] );
						}
					} else {
						$extra_urls = array();
						if ( ! empty( $meta['_um_extra_allowed_urls'][0] ) ) {
							$extra_urls = array_map( 'rtrim', explode( "\n", $meta['_um_extra_allowed_urls'][0] ) );
						}

						if ( is_home() || is_front_page() ) {
							if ( empty( $meta['_um_show_in_home'][0] ) ) {
								if ( ! empty( $extra_urls ) ) {
									if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
										unset( $user_notices[ $k ] );
									}
								} else {
									unset( $user_notices[ $k ] );
								}
							}
						} else {
							if ( empty( $meta['_um_show_in_pages'][0] ) && 'page' === get_post_type() ) {
								if ( ! empty( $extra_urls ) ) {
									if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
										unset( $user_notices[ $k ] );
									}
								} else {
									unset( $user_notices[ $k ] );
								}
							}

							if ( empty( $meta['_um_show_in_posts'][0] ) && 'post' === get_post_type() ) {
								if ( ! empty( $extra_urls ) ) {
									if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
										unset( $user_notices[ $k ] );
									}
								} else {
									unset( $user_notices[ $k ] );
								}
							}

							if ( ! in_array( get_post_type(), array( 'post', 'page' ), true ) ) {
								if ( ! empty( $meta['_um_show_in_types'][0] ) ) {
									$post_types = maybe_unserialize( $meta['_um_allowed_types'][0] );
									if ( ! empty( $post_types ) ) {
										if ( ! in_array( get_post_type(), $post_types, true ) ) {
											if ( ! empty( $extra_urls ) ) {
												if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
													unset( $user_notices[ $k ] );
												}
											} else {
												unset( $user_notices[ $k ] );
											}
										}
									} else {
										if ( ! empty( $extra_urls ) ) {
											if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
												unset( $user_notices[ $k ] );
											}
										} else {
											unset( $user_notices[ $k ] );
										}
									}
								} else {
									if ( ! empty( $extra_urls ) ) {
										if ( ! ( in_array( $current_url, $extra_urls, true ) || in_array( $current_url_slash, $extra_urls, true ) ) ) {
											unset( $user_notices[ $k ] );
										}
									} else {
										unset( $user_notices[ $k ] );
									}
								}
							}
						}
					}
				}
			}

			if ( $this->user_saw_this_notice( $notice_id ) ) {
				unset( $user_notices[ $k ] );
			}

			if ( ! empty( $meta['_um_show_loggedout'][0] ) && empty( $meta['_um_show_loggedin'][0] ) && is_user_logged_in() ) {
				unset( $user_notices[ $k ] );
			}

			if ( empty( $meta['_um_show_loggedout'][0] ) && ! empty( $meta['_um_show_loggedin'][0] ) && ! is_user_logged_in() ) {
				unset( $user_notices[ $k ] );
			}

			if ( empty( $meta['_um_show_loggedout'][0] ) && empty( $meta['_um_show_loggedin'][0] ) ) {
				// do not show_notice
				unset( $user_notices[ $k ] );
			}

			if ( is_user_logged_in() ) {
				if ( ! empty( $meta['_um_only_users'][0] ) ) {
					$meta['_um_only_users'][0] = maybe_unserialize( $meta['_um_only_users'][0] );
					if ( is_array( $meta['_um_only_users'][0] ) && ! in_array( get_current_user_id(), array_map( 'absint', $meta['_um_only_users'][0] ), true ) ) {
						unset( $user_notices[ $k ] );
					}
				} else {
					if ( isset( $meta['_um_roles'][0] ) ) {
						$roles              = maybe_unserialize( $meta['_um_roles'][0] );
						$current_user_roles = UM()->roles()->get_all_user_roles( get_current_user_id() );
						if ( $roles && ( empty( $current_user_roles ) || count( array_intersect( $current_user_roles, $roles ) ) <= 0 ) ) {
							unset( $user_notices[ $k ] );
						}
					}
				}

				if ( ! empty( $meta['_um_custom_field'][0] ) ) {
					if ( 'other' === $meta['_um_custom_field'][0] ) {
						$key = $meta['_um_custom_key'][0];
					} else {
						$key = $meta['_um_custom_field'][0];
					}

					if ( get_user_meta( get_current_user_id(), $key, true ) ) {
						unset( $user_notices[ $k ] );
					}

					if ( 'profile_photo' === $key ) {
						if ( get_user_meta( get_current_user_id(), 'synced_profile_photo', true ) ) {
							unset( $user_notices[ $k ] );
						}
					}
				}

				// EDD Integration
				if ( class_exists( 'Easy_Digital_Downloads' ) ) {
					if ( isset( $meta['_um_edd_users'][0] ) && 2 === absint( $meta['_um_edd_users'][0] ) ) { // made purchases

						$user = edd_get_purchase_stats_by_user( get_current_user_id() );
						if ( $meta['_um_edd_users_amount'][0] > 0 && $user['total_spent'] < $meta['_um_edd_users_amount'][0] ) {
							unset( $user_notices[ $k ] );
						}

						if ( ! edd_has_purchases( get_current_user_id() ) ) {
							unset( $user_notices[ $k ] );
						}
					} elseif ( ! empty( $meta['_um_edd_users'][0] ) ) { // did not make purchases
						if ( edd_has_purchases( get_current_user_id() ) ) {
							unset( $user_notices[ $k ] );
						}
					}
				}
			}
		}

		if ( ! empty( $user_notices ) ) {
			reset( $user_notices );
			$first_key       = key( $user_notices );
			$this->notice_id = $user_notices[ $first_key ];
		} else {
			$this->notice_id = 0;
		}
	}

	/**
	 * Boolean if user saw this notice
	 *
	 * @param $notice_id
	 *
	 * @return bool
	 */
	public function user_saw_this_notice( $notice_id ) {
		if ( is_user_logged_in() ) {
			$users = get_post_meta( $notice_id, '_users', true );
			if ( $users && is_array( $users ) && in_array( get_current_user_id(), $users ) ) {
				return true;
			}
		} elseif ( isset( $_COOKIE[ 'um_notice_seen_' . $notice_id ] ) ) {
			return true;
		}
		return false;
	}
}
