<?php
namespace um_ext\um_notices\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Notices_Metabox
 * @package um_ext\um_notices\core
 */
class Notices_Metabox {

	/**
	 * Notices_Metabox constructor.
	 */
	public function __construct() {
		add_action( 'load-post.php', array( &$this, 'add_metabox' ), 9 );
		add_action( 'load-post-new.php', array( &$this, 'add_metabox' ), 9 );
	}

	/**
	 * Init the metaboxes
	 */
	public function add_metabox() {
		global $current_screen;

		if ( 'um_notice' === $current_screen->id ) {
			add_action( 'add_meta_boxes', array( &$this, 'add_metabox_form' ), 1 );
			add_action( 'save_post', array( &$this, 'save_metabox_form' ), 10, 2 );
		}
	}

	/**
	 * Add form metabox
	 */
	public function add_metabox_form() {
		add_meta_box(
			'um-admin-custom-options{' . UM_NOTICES_PATH . '}',
			__( 'Options', 'um-notices' ),
			array( UM()->metabox(), 'load_metabox_custom' ),
			'um_notice',
			'normal'
		);
		add_meta_box(
			'um-admin-custom-rules{' . UM_NOTICES_PATH . '}',
			__( 'Footer Rules', 'um-notices' ),
			array( UM()->metabox(), 'load_metabox_custom' ),
			'um_notice',
			'normal'
		);
		add_meta_box(
			'um-admin-custom-styling{' . UM_NOTICES_PATH . '}',
			__( 'Styling', 'um-notices' ),
			array( UM()->metabox(), 'load_metabox_custom' ),
			'um_notice',
			'normal'
		);
		add_meta_box(
			'um-admin-custom-cta{' . UM_NOTICES_PATH . '}',
			__( 'CTA (Call to Action)', 'um-notices' ),
			array( UM()->metabox(), 'load_metabox_custom' ),
			'um_notice',
			'normal'
		);
		add_meta_box(
			'um-admin-custom-notice{' . UM_NOTICES_PATH . '}',
			__( 'This Notice', 'um-notices' ),
			array( UM()->metabox(), 'load_metabox_custom' ),
			'um_notice',
			'side'
		);
	}

	private function get_meta_map() {
		$fields = array(
			'_um_cta'                => array(
				'sanitize' => 'absint',
			),
			'_um_cta_text'           => array(
				'sanitize' => 'text',
			),
			'_um_cta_url'            => array(
				'sanitize' => 'url',
			),
			'_um_cta_bg'             => array(
				'sanitize' => 'text',
			),
			'_um_cta_clr'            => array(
				'sanitize' => 'text',
			),
			'_um_show_in_footer'     => array(
				'sanitize' => 'absint',
			),
			'_um_show_loggedout'     => array(
				'sanitize' => 'absint',
			),
			'_um_show_loggedin'      => array(
				'sanitize' => 'absint',
			),
			'_um_roles'              => array(
				'sanitize' => array( UM()->admin(), 'sanitize_existed_role' ),
			),
			'_um_custom_field'       => array(
				'sanitize' => 'text',
			),
			'_um_custom_key'         => array(
				'sanitize' => 'text',
			),
			'_um_only_users'         => array(
				'sanitize' => 'absint',
			),
			'_um_show_in_urls'       => array(
				'sanitize' => 'absint',
			),
			'_um_allowed_urls'       => array(
				'sanitize' => 'textarea',
			),
			'_um_extra_allowed_urls' => array(
				'sanitize' => 'textarea',
			),
			'_um_show_everywhere'    => array(
				'sanitize' => 'absint',
			),
			'_um_show_in_home'       => array(
				'sanitize' => 'absint',
			),
			'_um_show_in_posts'      => array(
				'sanitize' => 'absint',
			),
			'_um_show_in_pages'      => array(
				'sanitize' => 'absint',
			),
			'_um_show_in_types'      => array(
				'sanitize' => 'absint',
			),
			'_um_allowed_types'      => array(
				'sanitize' => 'key',
			),
			'_um_min_width'          => array(
				'sanitize' => 'text',
			),
			'_um_bgcolor'            => array(
				'sanitize' => 'text',
			),
			'_um_textcolor'          => array(
				'sanitize' => 'text',
			),
			'_um_fontsize'           => array(
				'sanitize' => 'text',
			),
			'_um_icon'               => array(
				'sanitize' => 'text',
			),
			'_um_iconcolor'          => array(
				'sanitize' => 'text',
			),
			'_um_closeiconcolor'     => array(
				'sanitize' => 'text',
			),
			'_um_border'             => array(
				'sanitize' => 'text',
			),
			'_um_border_radius'      => array(
				'sanitize' => 'text',
			),
			'_um_boxshadow'          => array(
				'sanitize' => 'text',
			),
		);

		if ( class_exists( 'Easy_Digital_Downloads' ) ) {
			$fields = array_merge(
				$fields,
				array(
					'_um_edd_users'        => array(
						'sanitize' => 'absint',
					),
					'_um_edd_users_amount' => array(
						'sanitize' => 'text',
					),
				)
			);
		}

		return apply_filters( 'um_notices_meta_map', $fields );
	}

	/**
	 * Sanitize notice meta when wp-admin form has been submitted
	 *
	 * @todo checking all sanitize types
	 *
	 * @param array $data
	 *
	 * @return array
	 */
	private function sanitize_notice_meta( $data ) {
		$sanitized    = array();
		$sanitize_map = $this->get_meta_map();
		foreach ( $data as $k => $v ) {
			if ( ! array_key_exists( $k, $sanitize_map ) ) {
				$sanitized[ $k ] = $v;
				continue;
			}

			if ( ! array_key_exists( 'sanitize', $sanitize_map[ $k ] ) ) {
				$sanitized[ $k ] = $v;
				continue;
			}

			if ( is_callable( $sanitize_map[ $k ]['sanitize'], true, $callable_name ) ) {
				add_filter( 'um_notice_meta_sanitize_' . $k, $sanitize_map[ $k ]['sanitize'], 10, 1 );
			}

			switch ( $sanitize_map[ $k ]['sanitize'] ) {
				default:
					$sanitized[ $k ] = apply_filters( 'um_notice_meta_sanitize_' . $k, $data[ $k ] );
					break;
				case 'int':
					$sanitized[ $k ] = (int) $v;
					break;
				case 'bool':
					$sanitized[ $k ] = (bool) $v;
					break;
				case 'url':
					if ( is_array( $v ) ) {
						$sanitized[ $k ] = array_map( 'esc_url_raw', $v );
					} else {
						$sanitized[ $k ] = esc_url_raw( $v );
					}
					break;
				case 'text':
					$sanitized[ $k ] = sanitize_text_field( $v );
					break;
				case 'textarea':
					$sanitized[ $k ] = sanitize_textarea_field( $v );
					break;
				case 'key':
					if ( is_array( $v ) ) {
						$sanitized[ $k ] = array_map( 'sanitize_key', $v );
					} else {
						$sanitized[ $k ] = sanitize_key( $v );
					}
					break;
				case 'absint':
					if ( is_array( $v ) ) {
						$sanitized[ $k ] = array_map( 'absint', $v );
					} else {
						$sanitized[ $k ] = absint( $v );
					}
					break;
			}
		}

		$data = $sanitized;

		$data = apply_filters( 'um_save_notice_meta_sanitize', $data );

		return $data;
	}

	/**
	 * Save form metabox
	 *
	 * @param $post_id
	 * @param $post
	 */
	public function save_metabox_form( $post_id, $post ) {
		// validate nonce
		if ( ! isset( $_POST['um_admin_save_metabox_custom_nonce'] ) ||
			! wp_verify_nonce( $_POST['um_admin_save_metabox_custom_nonce'], basename( UM_PATH . 'includes/admin/core/class-admin-metabox.php' ) ) ) {
			return;
		}

		// validate post type
		if ( 'um_notice' !== $post->post_type ) {
			return;
		}

		// validate user
		$post_type = get_post_type_object( $post->post_type );
		if ( null === $post_type || ! current_user_can( $post_type->cap->edit_post, $post_id ) ) {
			return;
		}

		$meta = $this->sanitize_notice_meta( wp_unslash( $_POST['notice'] ) );
		// save
		delete_post_meta( $post_id, '_um_roles' );
		foreach ( $meta as $k => $v ) {
			if ( false !== strpos( $k, '_um_' ) ) {
				update_post_meta( $post_id, $k, $v );
			}
		}
	}
}
