<?php
namespace um_ext\um_notices\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Notices_Admin
 * @package um_ext\um_notices\core
 */
class Notices_Admin {

	/**
	 * @var string
	 */
	public $slug = 'ultimatemember';

	/**
	 * Notices_Admin constructor.
	 */
	public function __construct() {
		add_action( 'um_extend_admin_menu', array( &$this, 'um_extend_admin_menu' ), 800 );
		add_filter( 'enter_title_here', array( &$this, 'enter_title_here' ) );

		add_filter( 'manage_edit-um_notice_columns', array( &$this, 'manage_edit_um_notice_columns' ) );
		add_action( 'manage_um_notice_posts_custom_column', array( &$this, 'manage_um_notice_posts_custom_column' ), 10, 3 );

		add_action( 'um_admin_do_action__flush_notice', array( &$this, 'um_admin_do_action__flush_notice' ) );
		add_filter( 'um_adm_action_individual_nonce_actions', array( &$this, 'um_adm_action_individual_nonce_actions' ) );

		add_filter( 'wp_insert_post_data', array( &$this, 'um_notices_content_validation' ), 10, 2 );
		add_action( 'admin_notices', array( &$this, 'admin_notices' ) );
		add_action( 'admin_notices', array( &$this, 'empty_allowed_types_admin_notice' ) );
		add_action( 'admin_notices', array( &$this, 'empty_allowed_urls_admin_notice' ) );
		add_action( 'admin_notices', array( &$this, 'empty_custom_field_admin_notice' ) );
		add_action( 'admin_notices', array( &$this, 'empty_cta_text_admin_notice' ) );
		add_action( 'admin_notices', array( &$this, 'empty_cta_url_admin_notice' ) );
	}

	/**
	 * Flush a notice.
	 */
	public function um_admin_do_action__flush_notice() {
		if ( empty( $_REQUEST['notice_id'] ) || empty( $_REQUEST['_wpnonce'] ) || ! wp_verify_nonce( $_REQUEST['_wpnonce'], "flush_notice{$_REQUEST['notice_id']}" ) ) {
			wp_die( esc_html__( 'Security check', 'um-notices' ) );
		}

		if ( ! is_numeric( $_REQUEST['notice_id'] ) ) {
			die();
		}

		delete_post_meta( absint( $_REQUEST['notice_id'] ), '_users' );

		$url = remove_query_arg( 'um_adm_action' );
		wp_safe_redirect( $url );
		exit;
	}

	public function um_adm_action_individual_nonce_actions( $actions ) {
		$actions[] = 'flush_notice';
		return $actions;
	}

	/**
	 * Custom title
	 *
	 * @param string $title
	 *
	 * @return string
	 */
	function enter_title_here( $title ) {
		$screen = get_current_screen();
		if ( 'um_notice' === $screen->post_type ) {
			$title = __( 'Enter notice title here', 'um-notices' );
		}

		return $title;
	}

	/**
	 * Extends the admin menu
	 */
	function um_extend_admin_menu() {
		add_submenu_page( $this->slug, __( 'Notices', 'um-notices' ), __( 'Notices', 'um-notices' ), 'manage_options', 'edit.php?post_type=um_notice', '' );
	}

	/**
	 * Add columns
	 *
	 * @param array $columns
	 *
	 * @return array
	 */
	function manage_edit_um_notice_columns( $columns ) {
		$columns['shortcode'] = __( 'Shortcode', 'um-notices' );
		$columns['reach']     = __( 'Reach', 'um-notices' ) . UM()->tooltip( __( 'How many people reached this notice? Count users who seen and closed the notice only', 'um-notices' ) );
		return $columns;
	}

	/**
	 * Show columns
	 *
	 * @param string $column_name
	 * @param int $id
	 */
	function manage_um_notice_posts_custom_column( $column_name, $id ) {
		switch ( $column_name ) {
			case 'shortcode':
				echo '[ultimatemember_notice id="' . $id . '" /]';
				break;
			case 'reach':
				$count = 0;
				$users = get_post_meta( $id, '_users', true );
				if ( is_array( $users ) ) {
					$count = count( $users );
				}

				echo '<span class="um-notices-counter"><i class="fas fa-chart-simple"></i> ' . $count . '</span>';
				break;
		}
	}

	/**
	 * Validate notice content
	 *
	 * @param array $data
	 * @param array $postarr
	 *
	 * @return array
	 */
	public function um_notices_content_validation( $data, $postarr ) {
		if ( 'um_notice' === $data['post_type'] && 'trash' !== $data['post_status'] && 'auto-draft' !== $data['post_status'] ) {
			if ( empty( $data['post_content'] ) ) {
				$data['post_status'] = 'draft';
				add_filter( 'redirect_post_location', array( $this, 'add_notice_query_var' ), 99 );
				return $data;
			}

			if ( ! empty( $_REQUEST['notice'] ) && empty( $_REQUEST['notice']['_um_show_everywhere'] ) && empty( $_REQUEST['notice']['_um_show_in_urls'] ) && ! empty( $_REQUEST['notice']['_um_show_in_types'] ) && empty( $_REQUEST['notice']['_um_allowed_types'] ) ) {
				$data['post_status'] = 'draft';
				add_filter( 'redirect_post_location', array( $this, 'add_allowed_types_notice_query_var' ), 99 );
				return $data;
			}

			if ( ! empty( $_REQUEST['notice'] ) && empty( $_REQUEST['notice']['_um_show_everywhere'] ) && ! empty( $_REQUEST['notice']['_um_show_in_urls'] ) && empty( $_REQUEST['notice']['_um_allowed_urls'] ) ) {
				$data['post_status'] = 'draft';
				add_filter( 'redirect_post_location', array( $this, 'add_allowed_urls_notice_query_var' ), 99 );
				return $data;
			}

			if ( ! empty( $_REQUEST['notice'] ) && ! empty( $_REQUEST['notice']['_um_show_loggedin'] ) ) {
				if ( isset( $_REQUEST['notice']['_um_custom_field'] ) && 'other' === $_REQUEST['notice']['_um_custom_field'] ) {
					if ( empty( $_REQUEST['notice']['_um_custom_key'] ) ) {
						$data['post_status'] = 'draft';
						add_filter( 'redirect_post_location', array( $this, 'add_empty_custom_field_notice_query_var' ), 99 );
						return $data;
					}
				}
			}

			if ( ! empty( $_REQUEST['notice'] ) && ! empty( $_REQUEST['notice']['_um_cta'] ) && empty( $_REQUEST['notice']['_um_cta_text'] ) ) {
				$data['post_status'] = 'draft';
				add_filter( 'redirect_post_location', array( $this, 'add_cta_text_notice_query_var' ), 99 );
				return $data;
			}

			if ( ! empty( $_REQUEST['notice'] ) && ! empty( $_REQUEST['notice']['_um_cta'] ) && empty( $_REQUEST['notice']['_um_cta_url'] ) ) {
				$data['post_status'] = 'draft';
				add_filter( 'redirect_post_location', array( $this, 'add_cta_url_notice_query_var' ), 99 );
				return $data;
			}
		}

		return $data;
	}

	public function add_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_notice_query_var' ), 99 );
		$args = array(
			'empty_content' => 1,
			'message'       => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	public function add_allowed_types_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_allowed_types_notice_query_var' ), 99 );
		$args = array(
			'empty_allowed_types' => 1,
			'message'             => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	public function add_allowed_urls_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_allowed_urls_notice_query_var' ), 99 );
		$args = array(
			'empty_allowed_urls' => 1,
			'message'            => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	public function add_empty_custom_field_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_empty_custom_field_notice_query_var' ), 99 );
		$args = array(
			'empty_custom_field_content' => 1,
			'message'                    => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	/**
	 * @param $location
	 *
	 * @return string
	 */
	public function add_cta_text_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_cta_text_notice_query_var' ), 99 );
		$args = array(
			'empty_cta_text_content' => 1,
			'message'                => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	/**
	 * @param $location
	 *
	 * @return string
	 */
	public function add_cta_url_notice_query_var( $location ) {
		remove_filter( 'redirect_post_location', array( $this, 'add_cta_url_notice_query_var' ), 99 );
		$args = array(
			'empty_cta_url_content' => 1,
			'message'               => 10, // is related to wp-admin/edit-form-advanced.php::line 193
		);
		return add_query_arg( $args, $location );
	}

	/**
	 * Add admin notice
	 */
	public function admin_notices() {
		if ( ! isset( $_GET['empty_content'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php esc_html_e( 'The notice can\'t be published. Please fill the content field.', 'um-notices' ); ?></p>
		</div>
		<?php
	}

	public function empty_allowed_types_admin_notice() {
		if ( ! isset( $_GET['empty_allowed_types'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php echo wp_kses( __( 'The notice can\'t be published. Please fill the <strong>"Choose Post Types"</strong> field.', 'um-notices' ), UM()->get_allowed_html( 'admin_notice' ) ); ?></p>
		</div>
		<?php
	}

	/**
	 *
	 */
	public function empty_allowed_urls_admin_notice() {
		if ( ! isset( $_GET['empty_allowed_urls'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php echo wp_kses( __( 'The notice can\'t be published. Please fill the <strong>"Enter allowed URLs one per line"</strong> field.', 'um-notices' ), UM()->get_allowed_html( 'admin_notice' ) ); ?></p>
		</div>
		<?php
	}

	/**
	 * Add admin notice
	 */
	public function empty_custom_field_admin_notice() {
		if ( ! isset( $_GET['empty_custom_field_content'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php echo wp_kses( __( 'The notice can\'t be published. Please fill the <strong>"Show If the user did not fill that metakey"</strong> field.', 'um-notices' ), UM()->get_allowed_html( 'admin_notice' ) ); ?></p>
		</div>
		<?php
	}

	/**
	 * Add admin notice
	 */
	public function empty_cta_text_admin_notice() {
		if ( ! isset( $_GET['empty_cta_text_content'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php echo wp_kses( __( 'The notice can\'t be published. Please fill the <strong>"Button Text"</strong> field.', 'um-notices' ), UM()->get_allowed_html( 'admin_notice' ) ); ?></p>
		</div>
		<?php
	}

	/**
	 * Add admin notice
	 */
	public function empty_cta_url_admin_notice() {
		if ( ! isset( $_GET['empty_cta_url_content'] ) ) {
			return;
		}
		?>
		<div class="error">
			<p><?php echo wp_kses( __( 'The notice can\'t be published. Please fill the <strong>"Button URL"</strong> field.', 'um-notices' ), UM()->get_allowed_html( 'admin_notice' ) ); ?></p>
		</div>
		<?php
	}
}
