<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post_id;
$types = get_post_types(
	array(
		'public'   => true,
		'_builtin' => false,
	),
	'objects'
);

unset( $types['post'], $types['page'] );
$post_types_options = array();
foreach ( $types as $key => $post_type_data ) {
	$post_types_options[ $key ] = $post_type_data->labels->singular_name;
}

$fields = array(
	array(
		'id'    => '_um_show_everywhere',
		'type'  => 'checkbox',
		'label' => __( 'Show everywhere on website', 'um-notices' ),
		'value' => UM()->query()->get_meta_value( '_um_show_everywhere', null, 0 ),
	),
	array(
		'id'          => '_um_show_in_urls',
		'type'        => 'checkbox',
		'label'       => __( 'Show on specific URLs only', 'um-notices' ),
		'value'       => UM()->query()->get_meta_value( '_um_show_in_urls', null, 0 ),
		'conditional' => array( '_um_show_everywhere', '=', 0 ),
	),
	array(
		'id'          => '_um_allowed_urls',
		'type'        => 'textarea',
		'required'    => true,
		'label'       => __( 'Enter allowed URLs one per line', 'um-notices' ),
		'value'       => UM()->query()->get_meta_value( '_um_allowed_urls', null, 'na' ),
		'description' => __( 'Notice will be displayed only on the specified above URLs.', 'um-notices' ),
		'conditional' => array( '_um_show_in_urls', '=', 1 ),
	),
	array(
		'id'          => '_um_show_in_home',
		'type'        => 'checkbox',
		'label'       => __( 'Show on Homepage', 'um-notices' ),
		'value'       => UM()->query()->get_meta_value( '_um_show_in_home', null, 1 ),
		'conditional' => array( '_um_show_in_urls', '=', 0 ),
	),
	array(
		'id'          => '_um_show_in_posts',
		'type'        => 'checkbox',
		'label'       => __( 'Show on Posts', 'um-notices' ),
		'value'       => UM()->query()->get_meta_value( '_um_show_in_posts', null, 1 ),
		'conditional' => array( '_um_show_in_urls', '=', 0 ),
	),
	array(
		'id'          => '_um_show_in_pages',
		'type'        => 'checkbox',
		'label'       => __( 'Show on Pages', 'um-notices' ),
		'value'       => UM()->query()->get_meta_value( '_um_show_in_pages', null, 1 ),
		'conditional' => array( '_um_show_in_urls', '=', 0 ),
	),
);

if ( ! empty( $post_types_options ) ) {
	$allowed_types = get_post_meta( $post_id, '_um_allowed_types', true );
	$allowed_types = ! empty( $allowed_types ) ? $allowed_types : array();

	$fields = array_merge(
		$fields,
		array(
			array(
				'id'          => '_um_show_in_types',
				'type'        => 'checkbox',
				'label'       => __( 'Show on Custom Post Types', 'um-notices' ),
				'value'       => UM()->query()->get_meta_value( '_um_show_in_types', null, 'na' ),
				'conditional' => array( '_um_show_in_urls', '=', 0 ),
			),
			array(
				'id'          => '_um_allowed_types',
				'type'        => 'select',
				'required'    => true,
				'multi'       => true,
				'label'       => __( 'Choose Post Types', 'um-notices' ),
				'value'       => ! empty( $allowed_types ) ? $allowed_types : array(),
				'options'     => $post_types_options,
				'conditional' => array( '_um_show_in_types', '=', 1 ),
				'description' => __( 'Choose Post Types', 'um-notices' ),
			),
		)
	);
} else {
	$fields = array_merge(
		$fields,
		array(
			array(
				'id'    => '_um_show_in_types',
				'type'  => 'hidden',
				'value' => '0',
			),
			array(
				'id'    => '_um_allowed_types',
				'type'  => 'hidden',
				'value' => '',
			),
		)
	);
}

$fields = array_merge(
	$fields,
	array(
		array(
			'id'          => '_um_extra_allowed_urls',
			'type'        => 'textarea',
			'label'       => __( 'Extra allowed URLs one per line', 'um-notices' ),
			'value'       => UM()->query()->get_meta_value( '_um_extra_allowed_urls', null, 'na' ),
			'tooltip'     => __( 'Specify additional URLs where you want to see the notice.', 'um-notices' ),
			// translators: %s - home page URL
			'description' => sprintf( __( '<strong>Note:</strong> If "Show on Homepage" is disabled, but you specified `%s` here, then notice should be visible.', 'um-notices' ), home_url() ),
			'conditional' => array( '_um_show_in_urls', '=', 0 ),
		),
	)
);
?>

<div class="um-admin-metabox">
	<?php
	UM()->admin_forms(
		array(
			'class'     => 'um-form-notice-rules um-half-column',
			'prefix_id' => 'notice',
			'fields'    => $fields,
		)
	)->render_form();
	?>
	<div class="clear"></div>
</div>
