<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$flush = add_query_arg(
	array(
		'um_adm_action' => 'flush_notice',
		'notice_id'     => get_the_ID(),
		'_wpnonce'      => wp_create_nonce( 'flush_notice' . get_the_ID() ),
	)
);

$count = 0;
$users = get_post_meta( get_the_ID(), '_users', true );
if ( is_array( $users ) ) {
	$count = count( $users );
}
?>

<div class="um-admin-metabox">
	<h6><?php esc_html_e( 'Shortcode', 'um-notices' ); ?></h6>
	<p>[ultimatemember_notice id="<?php echo esc_html( get_the_ID() ); ?>" /]</p>

	<div class="um-notices-metabox-block">
		<h6><?php esc_html_e( 'Reach', 'um-notices' ); ?></h6>
		<p><span class="um-notices-counter"><i class="fas fa-chart-simple"></i> <?php echo esc_html( $count ); ?></span></p>
	</div>

	<div class="um-notices-metabox-block">
		<h6><?php esc_html_e( 'Flush', 'um-notices' ); ?></h6>
		<p><?php esc_html_e( 'Flushing a notice makes it appear as a new notice to users even those who have seen it already.', 'um-notices' ); ?></p>
		<p><a href="<?php echo esc_url( $flush ); ?>" class="button"><?php esc_html_e( 'Flush this notice', 'um-notices' ); ?></a></p>
	</div>
</div>
