<?php
namespace um_ext\um_notices\admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Site_Health
 * @package um_ext\um_notices\admin
 */
class Site_Health {

	/**
	 * Site_Health constructor.
	 */
	public function __construct() {
		add_filter( 'um_get_outdated_icons_result', array( &$this, 'check_site_health' ), 10, 2 );
	}

	public function check_site_health( $result, $old_icons ) {
		$notices = get_posts(
			array(
				'post_type'      => 'um_notice',
				'posts_per_page' => -1,
				'fields'         => 'ids',
			)
		);

		$notices_count = 0;
		$break_notices = array();
		if ( ! empty( $notices ) ) {
			foreach ( $notices as $notice_id ) {
				$icon = get_post_meta( $notice_id, '_um_icon', true );
				if ( empty( $icon ) ) {
					continue;
				}
				if ( in_array( $icon, $old_icons, true ) ) {
					$break_notices[] = array(
						'id'    => $notice_id,
						'title' => get_the_title( $notice_id ),
						'link'  => get_edit_post_link( $notice_id ),
					);
					$notices_count++;
				}
			}
		}

		if ( 0 < $notices_count ) {
			$result['description'] .= sprintf(
				'<p>%s</p>',
				__( 'Your icons in the Ultimate Member Notices are out of date.', 'um-notices' )
			);

			if ( ! empty( $break_notices ) ) {
				$result['description'] .= sprintf(
					'<p>%s',
					__( 'Related to Ultimate Member Notices: ', 'um-notices' )
				);

				$notice_links = array();
				foreach ( $break_notices as $break_notice ) {
					$notice_links[] = sprintf(
						'<a href="%s" target="_blank">%s (#ID: %s)</a>',
						esc_url( $break_notice['link'] ),
						esc_html( $break_notice['title'] ),
						esc_html( $break_notice['id'] )
					);
				}

				$result['description'] .= sprintf(
					'%s</p><hr />',
					implode( ', ', $notice_links )
				);
			}

			$result['actions'] .= sprintf(
				'<p><a href="%s">%s</a></p>',
				admin_url( 'edit.php?post_type=um_notice' ),
				esc_html__( 'Edit notices and update', 'um-notices' )
			);
		}

		return $result;
	}
}
