<?php
namespace um_ext\um_notices\admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Enqueue
 * @package um_ext\um_notices\admin
 */
class Enqueue {

	/**
	 * Enqueue constructor.
	 */
	public function __construct() {
		add_action( 'load-post-new.php', array( &$this, 'enqueue_cpt_scripts' ) );
		add_action( 'load-post.php', array( &$this, 'enqueue_cpt_scripts' ) );
		add_action( 'load-edit.php', array( &$this, 'enqueue_cpt_scripts' ) );
	}

	public function enqueue_cpt_scripts() {
		if ( ( isset( $_GET['post_type'] ) && 'um_notice' === sanitize_key( $_GET['post_type'] ) ) || ( isset( $_GET['post'] ) && 'um_notice' === get_post_type( absint( $_GET['post'] ) ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts' ) );
		}
	}

	/**
	 * Enqueue
	 */
	public function admin_enqueue_scripts( $hook ) {
		$suffix = UM()->admin()->enqueue()::get_suffix();
		wp_register_style( 'um_notices_admin', um_notices_url . 'assets/css/admin/um-notices' . $suffix . '.css', array(), um_notices_version );
		wp_enqueue_style( 'um_notices_admin' );
	}
}
