<?php
/**
 * Template for the single badge.
 *
 * @version 2.2.4
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-mycred/single-badge.php
 * @var int    $level
 * @var int    $width
 * @var int    $height
 * @var string $image_url
 * @var string $title
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$badge_img_class = MYCRED_SLUG . '-badge-image badge-level' . $level . ' ' . MYCRED_SLUG . '-badge um-tip-n';
?>

<div class="the-badge the-badge-tipsy">
	<img width="<?php echo esc_attr( $width ); ?>" height="<?php echo esc_attr( $height ); ?>" src="<?php echo esc_url( $image_url ); ?>" class="<?php echo esc_attr( $badge_img_class ); ?>" title="<?php echo esc_attr( $title ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
</div>
