<?php
/**
 * Template for the UM myCRED.
 * Used on Profile page, Badges tab, All Badges subtab.
 *
 * Caller: method myCRED->show_badges_all()
 * @version 2.2.4
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-mycred/badges.php
 * @var array  $users_badges
 * @var array  $all_badges
 * @var array  $point_types
 * @var array  $references
 * @var object $mycred
 * @var int    $width
 * @var int    $height
 * @var int    $user_id
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$mycred_types = mycred_get_types();
?>

<div class="um-badges">
	<?php
	foreach ( $all_badges as $badge_id ) {
		$badge                = mycred_get_badge( $badge_id );
		$badge_title          = $badge->title;
		$image_identification = get_post_meta( $badge_id, 'main_image', true );
		$image_url            = wp_get_attachment_url( $image_identification );
		?>
		<div class="um-badge-wrapper">
			<div class="um-badge-title">
				<strong><?php echo esc_html( $badge_title ); ?></strong>
			</div>

			<?php
			if ( 1 < count( $badge->levels ) ) {
				foreach ( $badge->levels as $level_key => $level ) {
					?>
					<div class="um-badge-container">
						<?php
						$req_count = count( $level['requires'] );

						$image_title     = wp_strip_all_tags( apply_filters( 'um_mycred_badge_loop_title', $badge_title, $badge ) );
						$level_image_url = $badge->get_image_url( $level_key );
						if ( ! empty( $level_image_url ) ) {
							$image_url = $level_image_url;
						}

						// translators: %s - myCRED badge level ID.
						$level_label = sprintf( __( 'Level %s', 'um-mycred' ), $level_key + 1 );
						if ( ! empty( $level['label'] ) ) {
							$level_label = $level['label'];
						}

						$base_requirements = array();
						foreach ( $level['requires'] as $requirement_row => $requirement ) {
							if ( '' === $requirement['type'] ) {
								$requirement['type'] = MYCRED_DEFAULT_TYPE_KEY;
							}

							if ( ! array_key_exists( $requirement['type'], $point_types ) ) {
								continue;
							}

							if ( ! array_key_exists( $requirement['reference'], $references ) ) {
								$reference = '-';
							} else {
								$reference = $references[ $requirement['reference'] ];
							}
							$base_requirements[ $requirement_row ] = array(
								'type'   => $requirement['type'],
								'ref'    => $reference,
								'amount' => $requirement['amount'],
								'by'     => $requirement['by'],
							);
						}
						?>
						<div class="um-badge-row">
							<div class="um-badge-level-title">
								<?php echo esc_html( $level_label ); ?>
							</div>
							<div class="um-badge-level-earned">
								<?php
								if ( array_key_exists( $badge_id, $users_badges ) && $level_key === $users_badges[ $badge_id ] ) {
									echo '<span>' . esc_html__( 'Earned', 'um-mycred' ) . '</span>';
								}
								?>
							</div>
						</div>
						<div class="um-badge-row">
							<div class="um-badge-image">
								<?php if ( $image_url ) { ?>
									<img src="<?php echo esc_url( $image_url ); ?>" title="<?php echo esc_attr( $image_title ); ?>" alt="<?php echo esc_attr( $image_title ); ?>" width="<?php echo esc_attr( $width ); ?>" height="<?php echo esc_attr( $height ); ?>" class="mycred-badge earned um-tip-n" />
								<?php } ?>
							</div>
							<div class="um-badge-requirements">
								<?php if ( ! empty( $base_requirements ) ) { ?>
									<ul>
										<?php
										// From the `mycred_display_badge_requirements()` function.
										foreach ( $base_requirements as $requirement_row => $requirement ) {
											if ( empty( $requirement['amount'] ) || empty( $requirement['by'] ) ) {
												continue;
											}
											if ( 'count' === $requirement['by'] ) {
												// translators: %1$s is the points name, %2$s is the reference, %3$s is the amount
												$rendered_row = sprintf( _x( '%1$s for "%2$s" x %3$s', '"Points" for "reference" x times', 'um-mycred' ), $mycred->plural(), $requirement['ref'], $requirement['amount'] );
											} else {
												// translators: %1$s is the points name, %2$s is the reference, %3$s is the amount
												$rendered_row = sprintf( _x( '%1$s %2$s for "%3$s"', '"Gained/Lost" "x points" for "reference"', 'um-mycred' ), ( ( $requirement['amount'] < 0 ) ? __( 'Lost', 'um-mycred' ) : __( 'Gained', 'um-mycred' ) ), $mycred->format_creds( $requirement['amount'] ), $requirement['ref'] );
											}
											$compare = _x( 'OR', 'Comparison of badge requirements. A OR B', 'um-mycred' );
											if ( 'AND' === $level['compare'] ) {
												$compare = _x( 'AND', 'Comparison of badge requirements. A AND B', 'um-mycred' );
											}
											if ( 1 < $req_count && $requirement_row + 1 < $req_count ) {
												$rendered_row .= ' <span>' . $compare . '</span>';
											}
											echo '<li>' . wp_kses_post( $rendered_row ) . '</li>';
										}
										?>
									</ul>
								<?php } ?>
							</div>
						</div>
					</div>
					<?php
				}
			} else {
				$level_key       = 0;
				$level_image_url = $badge->get_image_url( $level_key );
				if ( ! empty( $level_image_url ) ) {
					$image_url = $level_image_url;
				}

				// translators: %s - myCRED badge level ID.
				$level_label = sprintf( __( 'Level %s', 'um-mycred' ), $level_key + 1 );
				if ( ! empty( $badge->levels[ $level_key ]['label'] ) ) {
					$level_label = $badge->levels[ $level_key ]['label'];
				}

				$badge_title        = wp_strip_all_tags( apply_filters( 'um_mycred_badge_loop_title', $badge_title, $badge ) );
				$badge_requirements = preg_replace( '/<strong>(.*?)<\/strong>/i', '', mycred_display_badge_requirements( $badge_id ) );
				?>
				<div class="um-badge-container">
					<div class="um-badge-row">
						<div class="um-badge-level-title">
							<?php echo esc_html( $level_label ); ?>
						</div>
						<div class="um-badge-level-earned">
							<?php
							if ( array_key_exists( $badge_id, $users_badges ) ) {
								echo '<span>' . esc_html__( 'Earned', 'um-mycred' ) . '</span>';
							}
							?>
						</div>
					</div>
					<div class="um-badge-row">
						<div class="um-badge-image">
							<?php if ( ! empty( $image_url ) ) { ?>
								<img src="<?php echo esc_url( $image_url ); ?>" title="<?php echo esc_attr( $badge_title ); ?>" alt="<?php echo esc_attr( $badge_title ); ?>" width="<?php echo esc_attr( $width ); ?>" height="<?php echo esc_attr( $height ); ?>" class="mycred-badge earned um-tip-n" />
							<?php } ?>
						</div>
						<div class="um-badge-requirements">
							<?php echo wp_kses( $badge_requirements, UM()->get_allowed_html( 'templates' ) ); ?>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	}
	?>
</div>
