<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class UM_myCRED
 */
class UM_myCRED {

	/**
	 * For backward compatibility with 1.3.x and PHP8.2 compatibility.
	 *
	 * @var bool
	 */
	public $plugin_inactive = false;

	/**
	 * @deprecated since 2.1.8
	 *
	 * @var string
	 */
	public $action = '';

	/**
	 * @var
	 */
	private static $instance;

	/**
	 * @return UM_myCRED
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * UM_myCRED constructor.
	 */
	public function __construct() {
		// Global for backwards compatibility.
		$GLOBALS['um_mycred'] = $this;
		add_filter( 'um_call_object_myCRED', array( &$this, 'get_this' ) );
		add_filter( 'um_settings_default_values', array( &$this, 'default_settings' ), 10, 1 );

		if ( UM()->is_request( 'admin' ) ) {
			$this->admin();
		}

		$this->enqueue();
		$this->account();
		$this->member_directory();
		$this->hooks();
		$this->rest();
		$this->profile();
		$this->notifications();
		$this->bbpress_integration();
		$this->fields();
		$this->shortcode();
	}

	/**
	 * @return $this
	 */
	public function get_this() {
		return $this;
	}

	/**
	 * @param array $defaults
	 *
	 * @return array
	 */
	public function default_settings( $defaults ) {
		$defaults = array_merge( $defaults, $this->setup()->settings_defaults );
		return $defaults;
	}

	/**
	 * @return um_ext\um_mycred\core\Admin()
	 */
	public function admin() {
		if ( empty( UM()->classes['um_mycred_admin'] ) ) {
			UM()->classes['um_mycred_admin'] = new um_ext\um_mycred\core\Admin();
		}
		return UM()->classes['um_mycred_admin'];
	}

	/**
	 * @return um_ext\um_mycred\core\Hooks()
	 */
	public function hooks() {
		if ( empty( UM()->classes['um_mycred_hooks'] ) ) {
			UM()->classes['um_mycred_hooks'] = new um_ext\um_mycred\core\Hooks();
		}
		return UM()->classes['um_mycred_hooks'];
	}

	/**
	 * @return um_ext\um_mycred\core\REST()
	 */
	public function rest() {
		if ( empty( UM()->classes['um_mycred_rest'] ) ) {
			UM()->classes['um_mycred_rest'] = new um_ext\um_mycred\core\REST();
		}
		return UM()->classes['um_mycred_rest'];
	}

	/**
	 * @return um_ext\um_mycred\core\Points()
	 */
	public function points() {
		if ( empty( UM()->classes['um_mycred_points'] ) ) {
			UM()->classes['um_mycred_points'] = new um_ext\um_mycred\core\Points();
		}
		return UM()->classes['um_mycred_points'];
	}

	/**
	 * @return um_ext\um_mycred\core\Profile()
	 */
	public function profile() {
		if ( empty( UM()->classes['um_mycred_profile'] ) ) {
			UM()->classes['um_mycred_profile'] = new um_ext\um_mycred\core\Profile();
		}
		return UM()->classes['um_mycred_profile'];
	}

	/**
	 * All badges are returned through shortcodes.
	 *
	 * @deprecated 2.2.4
	 *
	 * @return null
	 */
	public function badges() {
		_deprecated_function( __METHOD__, '2.2.4' );
		return null;
	}

	/**
	 * @return um_ext\um_mycred\core\Ranks()
	 */
	public function ranks() {
		if ( empty( UM()->classes['um_mycred_ranks'] ) ) {
			UM()->classes['um_mycred_ranks'] = new um_ext\um_mycred\core\Ranks();
		}
		return UM()->classes['um_mycred_ranks'];
	}

	/**
	 * @return um_ext\um_mycred\core\Notifications()
	 */
	public function notifications() {
		if ( empty( UM()->classes['um_mycred_notifications'] ) ) {
			UM()->classes['um_mycred_notifications'] = new um_ext\um_mycred\core\Notifications();
		}
		return UM()->classes['um_mycred_notifications'];
	}

	/**
	 * @return um_ext\um_mycred\core\bbPress_Integration()
	 */
	public function bbpress_integration() {
		if ( empty( UM()->classes['um_mycred_bbpress'] ) ) {
			UM()->classes['um_mycred_bbpress'] = new um_ext\um_mycred\core\bbPress_Integration();
		}
		return UM()->classes['um_mycred_bbpress'];
	}

	/**
	 * @return um_ext\um_mycred\core\Fields()
	 */
	public function fields() {
		if ( empty( UM()->classes['um_mycred_fields'] ) ) {
			UM()->classes['um_mycred_fields'] = new um_ext\um_mycred\core\Fields();
		}
		return UM()->classes['um_mycred_fields'];
	}

	/**
	 * @return um_ext\um_mycred\core\Fields()
	 */
	public function shortcode() {
		if ( empty( UM()->classes['um_mycred_shortcode'] ) ) {
			UM()->classes['um_mycred_shortcode'] = new um_ext\um_mycred\core\Shortcode();
		}
		return UM()->classes['um_mycred_shortcode'];
	}

	/**
	 * @return um_ext\um_mycred\core\Setup()
	 */
	public function setup() {
		if ( empty( UM()->classes['um_mycred_setup'] ) ) {
			UM()->classes['um_mycred_setup'] = new um_ext\um_mycred\core\Setup();
		}
		return UM()->classes['um_mycred_setup'];
	}

	/**
	 * @return um_ext\um_mycred\core\Enqueue()
	 */
	public function enqueue() {
		if ( empty( UM()->classes['um_mycred_enqueue'] ) ) {
			UM()->classes['um_mycred_enqueue'] = new um_ext\um_mycred\core\Enqueue();
		}
		return UM()->classes['um_mycred_enqueue'];
	}

	/**
	 * @return um_ext\um_mycred\core\Account()
	 */
	public function account() {
		if ( empty( UM()->classes['um_mycred_account'] ) ) {
			UM()->classes['um_mycred_account'] = new um_ext\um_mycred\core\Account();
		}
		return UM()->classes['um_mycred_account'];
	}

	/**
	 * @return um_ext\um_mycred\core\Member_Directory()
	 */
	public function member_directory() {
		if ( empty( UM()->classes['um_mycred_member_directory'] ) ) {
			UM()->classes['um_mycred_member_directory'] = new um_ext\um_mycred\core\Member_Directory();
		}
		return UM()->classes['um_mycred_member_directory'];
	}
}


if ( ! function_exists( 'um_init_mycred' ) ) {

	/**
	 * Initialize myCRED running and create class variable
	 */
	function um_init_mycred() {
		if ( function_exists( 'UM' ) ) {
			UM()->set_class( 'myCRED', true );
		}
	}
}
add_action( 'plugins_loaded', 'um_init_mycred', -10, 1 );
