<?php
namespace um_ext\um_mycred\core;

use myCRED_Badge;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Fields
 */
class Shortcode {

	public $um_badge_image = true;

	/**
	 * Fields constructor.
	 */
	public function __construct() {
		add_shortcode( 'ultimatemember_user_badges', array( &$this, 'ultimatemember_user_badges' ) );
		add_shortcode( 'ultimatemember_all_badges', array( &$this, 'ultimatemember_all_badges' ) );
	}

	/**
	 * Display user badges
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_user_badges( $args = array() ) {
		$defaults = array(
			'user_id' => get_current_user_id(),
		);
		$args     = shortcode_atts( $defaults, $args, 'ultimatemember_user_badges' );
		$user_id  = absint( $args['user_id'] );

		$output = '';

		if ( ! $user_id && ! is_user_logged_in() ) {
			return $output;
		}

		if ( ! function_exists( 'mycred_display_users_badges' ) ) {
			return $output;
		}

		wp_enqueue_script( 'um_mycred' );
		wp_enqueue_style( 'um_mycred' );

		$um_badge_image = apply_filters( 'um_mycred_badge_image', $this->um_badge_image );
		if ( true === $um_badge_image ) {
			add_filter( 'mycred_badge_image', array( &$this, 'mycred_badge_image' ), 10, 3 );
		}

		$t_args = compact( 'user_id' );
		return UM()->get_template( 'user-badges.php', um_mycred_plugin, $t_args );
	}

	/**
	 * Badge image.
	 *
	 * @param string       $html
	 * @param string       $image
	 * @param myCRED_Badge $data
	 *
	 * @return string
	 */
	public function mycred_badge_image( $html, $image, $data ) {
		$level = 'none';
		if ( 'main' !== $image && is_numeric( $image ) ) {
			$level = $image;
		}
		$image_url = $data->get_image_url( $image );
		if ( ! $image_url ) {
			return $html;
		}

		$width  = MYCRED_BADGE_WIDTH;
		$height = MYCRED_BADGE_HEIGHT;
		$size   = UM()->options()->get( 'mycred_badge_size' );
		if ( ! empty( $size ) && is_numeric( $size ) ) {
			$width  = $size;
			$height = $size;
		}

		$title = '';
		if ( ! empty( $data->title ) ) {
			$title .= $data->title;
		}
		if ( isset( $data->level['label'] ) && 1 < count( $data->levels ) ) {
			if ( ! empty( $data->title ) ) {
				$title .= ' - ';
			}

			// translators: %s - myCRED badge level ID.
			$level_label = sprintf( __( 'Level %s', 'um-mycred' ), absint( $level ) + 1 );
			if ( ! empty( $data->level['label'] ) ) {
				$level_label = $data->level['label'];
			}

			$title .= $level_label;
		}

		$t_args = compact( 'level', 'width', 'height', 'image_url', 'title' );
		return UM()->get_template( 'single-badge.php', um_mycred_plugin, $t_args );
	}

	/**
	 * Display user badges
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_all_badges( $args = array() ) {
		global $mycred;

		$defaults = array(
			'user_id' => get_current_user_id(),
		);
		$args     = shortcode_atts( $defaults, $args, 'ultimatemember_all_badges' );
		$user_id  = absint( $args['user_id'] );

		$output = '';

		$all_badges = mycred_get_badge_ids();

		if ( ! empty( $all_badges ) ) {
			wp_enqueue_script( 'um_mycred' );
			wp_enqueue_style( 'um_mycred' );

			$point_types  = mycred_get_types( true );
			$references   = mycred_get_all_references();
			$users_badges = mycred_get_users_badges( $user_id );

			$width  = MYCRED_BADGE_WIDTH;
			$height = MYCRED_BADGE_HEIGHT;
			$size   = UM()->options()->get( 'mycred_badge_size' );
			if ( ! empty( $size ) && is_numeric( $size ) ) {
				$width  = $size;
				$height = $size;
			}

			$output = UM()->get_template(
				'badges.php',
				um_mycred_plugin,
				compact( 'users_badges', 'mycred', 'width', 'height', 'all_badges', 'point_types', 'references', 'user_id' )
			);
		}

		return $output;
	}
}
