<?php namespace um_ext\um_mycred\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Class Profile
 */
class Profile {


	/**
	 * Profile constructor.
	 */
	public function __construct() {
		add_filter( 'um_profile_tabs', array( &$this, 'add_tab' ), 2000, 1 );
		add_filter( 'um_user_profile_tabs', array( &$this, 'add_subtabs' ), 2000, 1 );

		add_filter( 'mycred_get_users_badges', array( &$this, 'filter_user_badges' ) );

		add_action( 'um_after_profile_header_name', array( &$this, 'um_mycred_show_user_badges_profile_header' ), 70, 2 );

		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			// default tab is handled in UM core
		} else {
			add_action( 'um_profile_content_badges_default', array( &$this, 'um_mycred_show_user_badges' ) );
		}
		add_action( 'um_profile_content_badges_my_badges', array( &$this, 'um_mycred_show_user_badges' ) );
		add_action( 'um_profile_content_badges_all_badges', array( &$this, 'um_profile_content_badges_all_badges' ) );
	}

	/**
	 * Leave only published badges.
	 *
	 * @param array $clean_ids User badges.
	 *
	 * @return array
	 */
	public function filter_user_badges( $clean_ids ) {
		foreach ( $clean_ids as $badge_id => $level ) {
			$badge_post = get_post( $badge_id );
			if ( empty( $badge_post ) || 'publish' !== $badge_post->post_status ) {
				unset( $clean_ids[ $badge_id ] );
			}
		}

		return $clean_ids;
	}

	/**
	 * Adds a main tab to display badges in profile
	 *
	 * @param array $tabs
	 *
	 * @return array
	 */
	public function add_tab( $tabs ) {
		if ( ! function_exists( 'mycred_get_users_badges' ) ) {
			return $tabs;
		}

		$tabs['badges'] = array(
			'name' => __( 'Badges', 'um-mycred' ),
			'icon' => 'um-icon-ribbon-b',
		);

		return $tabs;
	}


	/**
	 * Add tabs based on user
	 *
	 * @param array $tabs
	 *
	 * @return array
	 */
	public function add_subtabs( $tabs ) {
		if ( empty( $tabs['badges'] ) ) {
			return $tabs;
		}

		$display_name = um_user( 'display_name' );
		if ( strstr( $display_name, ' ' ) ) {
			$display_name = explode( ' ', $display_name );
			$display_name = $display_name[0];
		}

		$tabs['badges']['subnav_default'] = 'my_badges';
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			$tabs['badges']['subnav'] = array(
				'my_badges'  => array(
					// translators: %s is the user's display name
					'title' => ( um_is_myprofile() ) ? __( 'Your Badges', 'um-mycred' ) : sprintf( __( '%s\'s Badges', 'um-mycred' ), $display_name ),
				),
				'all_badges' => array(
					'title' => __( 'All Badges', 'um-mycred' ),
				),
			);
		} else {
			$tabs['badges']['subnav'] = array(
				// translators: %s is the user's display name
				'my_badges'  => ( um_is_myprofile() ) ? __( 'Your Badges', 'um-mycred' ) : sprintf( __( '%s\'s Badges', 'um-mycred' ), $display_name ),
				'all_badges' => __( 'All Badges', 'um-mycred' ),
			);
		}

		return $tabs;
	}

	/**
	 * @todo find the best place in new UI.
	 * @param $args
	 * @param $user_id
	 *
	 * @return void
	 */
	public function um_mycred_show_user_badges_profile_header( $args = null, $user_id = null ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			return;
		}

		if ( ! UM()->options()->get( 'mycred_show_badges_in_header' ) ) {
			return;
		}

		if ( ! $user_id ) {
			$user_id = um_profile_id();
		}

		echo wp_kses( apply_shortcodes( '[ultimatemember_user_badges user_id="' . $user_id . '"]' ), UM()->get_allowed_html( 'templates' ) );
	}

	public function um_mycred_show_user_badges( $args ) {
		echo wp_kses( apply_shortcodes( '[ultimatemember_user_badges user_id="' . um_profile_id() . '"]' ), UM()->get_allowed_html( 'templates' ) );
	}

	/**
	 * Show all badges
	 *
	 * @param $args
	 */
	public function um_profile_content_badges_all_badges( $args ) {
		echo wp_kses( apply_shortcodes( '[ultimatemember_all_badges user_id="' . um_profile_id() . '"]' ), UM()->get_allowed_html( 'templates' ) );
	}
}
