<?php
namespace um_ext\um_mycred\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Enqueue
 * @package um_ext\um_mycred\core
 */
class Enqueue {

	/**
	 * Enqueue constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( &$this, 'wp_enqueue_scripts' ), 0 );
		add_action( 'enqueue_block_assets', array( &$this, 'block_editor' ), 11 );
	}

	/**
	 * Register frontend scripts/styles
	 */
	public function wp_enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();

		wp_register_script( 'um_mycred', um_mycred_url . 'assets/js/um-mycred' . $suffix . '.js', array( 'jquery', 'um_tipsy' ), um_mycred_version, true );
		wp_register_style( 'um_mycred', um_mycred_url . 'assets/css/um-mycred' . $suffix . '.css', array( 'um_tipsy' ), um_mycred_version );
	}

	public function block_editor() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();
		wp_register_style( 'um_mycred', um_mycred_url . 'assets/css/um-mycred' . $suffix . '.css', array( 'um_tipsy' ), um_mycred_version );
		wp_enqueue_style( 'um_mycred' );
	}
}
