<?php
/**
 * Template for the UM Private Messages.
 * Used to display 'Message' button.
 *
 * Shortcode: [ultimatemember_message_button]
 * Caller: method Messaging_Shortcode->ultimatemember_message_button()
 * @version 2.3.5
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-messaging/button.php
 * @var int    $user_id
 * @var string $title
 * @var string $redirect
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_user_logged_in() ) {
	$button = UM()->frontend()::layouts()::button(
		$title,
		array(
			'type'    => 'button',
			'size'    => 's',
			'classes' => array( 'um-message-btn', 'um-login-to-msg-btn' ),
			'title'   => $title,
			'data'    => array(
				'redirect'   => $redirect,
				'message_to' => $user_id,
				'nonce'      => wp_create_nonce( 'um_messaging_start_conversation' . $user_id ),
			),
		)
	);
} else {
	$button = UM()->frontend()::layouts()::button(
		$title,
		array(
			'type'    => 'button',
			'size'    => 's',
			'classes' => array( 'um-message-btn' ),
			'title'   => $title,
			'data'    => array(
				'message_to' => $user_id,
				'nonce'      => wp_create_nonce( 'um_messaging_start_conversation' . $user_id ),
			),
		)
	);
}

echo wp_kses( $button, UM()->get_allowed_html( 'templates' ) );
