<?php
/**
 * @Template: Single Group page
 *
 * Extension: Ultimate Member - Groups
 * Page: Group
 * Call: UM()->Groups()->shortcode()->single()
 *
 * @version 2.4.1
 *
 * @var int    $user_id2
 * @var array  $args
 * @var string $has_joined
 *
 * This template can be overridden by copying it to your-theme/ultimate-member/um-groups/single.php
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $um_group, $um_group_id;

$group           = is_a( $um_group, 'WP_Post' ) ? $um_group : get_post( $um_group_id );
$group->group_id = $um_group_id;
$group->user_id2 = $user_id2;
$groups          = array( $group );
?>

<div class="um um-groups-single">
	<div class="um-group-single-header">
		<?php
		$t_args = compact( 'args', 'groups' );
		if ( 'pending_member_review' === $has_joined ) {
			UM()->get_template( 'directory/directory-confirm.php', um_groups_plugin, $t_args, true );
		} else {
			UM()->get_template( 'directory/directory.php', um_groups_plugin, $t_args, true );
		}
		?>
		<div class="um-clear"></div>
	</div>

	<?php
	do_action( 'um_groups_before_page_tabs', $um_group_id );

	if ( is_user_logged_in() ) {
		do_action( 'um_groups_single_page_tabs', $um_group_id );

		$current_tab = UM()->Groups()->api()->current_group_tab;
		$sub_tab     = UM()->Groups()->api()->current_group_subtab;
		?>

		<div class="um-group-tab-content-wrap um-group-tab-content__<?php echo esc_attr( $current_tab ); ?>">
			<?php do_action( 'um_groups_single_page_content', $um_group_id, $current_tab, $sub_tab ); ?>
			<?php do_action( "um_groups_single_page_content__{$current_tab}", $um_group_id ); ?>
			<?php do_action( "um_groups_single_page_sub_content__{$current_tab}_{$sub_tab}", $um_group_id ); ?>
		</div>

		<?php
	} else {
		echo wp_kses( UM()->Groups()->discussion()->login_to_interact( $um_group_id ), UM()->get_allowed_html( 'templates' ) );
	}
	?>
</div>
