<?php
namespace um_ext\um_groups\core;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Class Groups_Setup
 * @package um_ext\um_groups\core
 */
class Groups_Setup {

	/**
	 * @var array
	 */
	var $settings_defaults;

	/**
	 * @var
	 */
	var $global_actions;

	/**
	 * @var string
	 */
	public $db_groups_table;


	/**
	 * Groups_Setup constructor.
	 */
	public function __construct() {
		global $wpdb;

		$this->global_actions['status']               = __( 'New wall post', 'um-groups' );
		$this->global_actions['new-user']             = __( 'New user', 'um-groups' );
		$this->global_actions['new-post']             = __( 'New blog post', 'um-groups' );
		$this->global_actions['new-product']          = __( 'New product', 'um-groups' );
		$this->global_actions['new-gform']            = __( 'New Gravity From', 'um-groups' );
		$this->global_actions['new-gform-submission'] = __( 'New Gravity From Answer', 'um-groups' );
		$this->global_actions['new-follow']           = __( 'New follow', 'um-groups' );
		$this->global_actions['new-topic']            = __( 'New forum topic', 'um-groups' );

		$this->db_groups_table = $wpdb->prefix . 'um_groups_members';

		// settings defaults
		$this->settings_defaults = array(

			// Join Request - Email template
			'groups_join_request_on'     => 1,
			'groups_join_request_sub'    => '{site_name} - Join Request',
			'groups_join_request'        => 'Hi {display_name},<br /><br />' .
					'{display_name} has requested to join {group_name}. You can view their profile here: {profile_link}<br /><br />' .
					'To approve/reject this request please click the following link: {groups_request_tab_url}<br /><br />',

			// Request Approved - Email Template
			'groups_approve_member_on'   => 1,
			'groups_approve_member_sub'  => '{site_name} - Your request to join {group_name} has been approved.',
			'groups_approve_member'      => 'Your request to join {group_name} has been approved.<br /><br />{group_url}',

			// New post - Email Template
			'groups_new_post_on'         => 1,
			'groups_new_post_sub'        => '{site_name} - {author_name} added a new post on group {group_name}',

			// New comment - Email Template
			'groups_new_comment_on'      => 1,
			'groups_new_comment_sub'     => '{site_name} - {author_name} added a new comment on post on group "{group_name}"',

			// Invited - Email Template
			'groups_invite_member_on'    => 1,
			'groups_invite_member_sub'   => '{site_name} - You have been invited to join {group_name}',
			'groups_invite_member'       => 'Hi {group_invitation_host_name},<br /><br />' .
					'{group_invitation_guest_name} has invited you to join {group_name}.<br /><br />' .
					'To confirm/reject this invitation please click the following link: {group_url}',

			'groups_invite_people'       => 'everyone',

			'groups_slug'                => 'um-groups',
			'group_category_slug'        => 'um-group-categories',
			'group_tag_slug'             => 'um-group-tags',
			'groups_show_avatars'        => 1,

			// Discussion settings
			'groups_posts_num'           => 10,
			'groups_posts_num_mob'       => 5,
			'groups_init_comments_count' => 2,
			'groups_load_comments_count' => 10,
			'groups_order_comment'       => 'asc',
			'groups_post_truncate'       => 25,
			'groups_enable_privacy'      => 1,
			'groups_trending_days'       => 7,
			'groups_require_login'       => 0,
			'groups_need_to_login'       => __( 'Please <a href="{register_page}" class="um-link">sign up</a> or <a href="{login_page}" class="um-link">sign in</a> to see group activity.', 'um-groups' ),
			'groups_highlight_color'     => '#0085ba',

		);

		// Real-time notification integration's default logs
		foreach ( $this->get_log_types_templates() as $k => $template ) {
			$this->settings_defaults[ 'log_' . $k ]               = 1;
			$this->settings_defaults[ 'log_' . $k . '_template' ] = $template;
		}

		foreach ( apply_filters( 'um_groups_discussion_global_actions', $this->global_actions ) as $k => $v ) {
			if ( 'status' === $k ) {
				continue;
			}

			$this->settings_defaults[ 'groups-discussion-' . $k ] = 1;
		}
	}


	/**
	 * Get default notification log templates
	 * @return array
	 */
	public function get_log_types_templates() {
		$array = array(
			'groups_approve_member' => __( 'Your request to join {group_name} have been approved.', 'um-groups' ),
			'groups_join_request'   => __( '{member_name} has requested to join {group_name}.', 'um-groups' ),
			'groups_invite_member'  => __( '{group_invitation_host_name} has invited you to join {group_name}.', 'um-groups' ),
			'groups_change_role'    => __( 'Your group role {group_role_old} has been changed to {group_role_new} in {group_name}.', 'um-groups' ),
			'groups_new_post'       => __( '<strong>{author_name}</strong> has just posted on the group <strong>{group_name}</strong>.', 'um-groups' ),
			'groups_new_comment'    => __( '<strong>{author_name}</strong> has just commented on the group <strong>{group_name}</strong>.', 'um-groups' ),
			'groups_new_mention'    => __( '<strong>{author_name}</strong> just mentioned you in the group <strong>{group_name}</strong>.', 'um-groups' ),
		);

		return apply_filters( 'um_groups_notifications_log_templates', $array );
	}


	/**
	 * Set default settings
	 */
	public function set_default_settings() {
		$options = get_option( 'um_options', array() );

		foreach ( $this->settings_defaults as $key => $value ) {
			//set new options to default
			if ( ! isset( $options[ $key ] ) ) {
				$options[ $key ] = $value;
			}
		}

		update_option( 'um_options', $options );
	}

	/**
	 *
	 */
	private function force_show_create_pages() {
		$version = get_option( 'um_groups_version' );

		if ( ! $version ) {
			$hidden_notices = get_option( 'um_hidden_admin_notices', array() );
			$hidden_notices = array_flip( $hidden_notices );
			unset( $hidden_notices['wrong_pages'] );
			$hidden_notices = array_flip( $hidden_notices );

			update_option( 'um_hidden_admin_notices', $hidden_notices );
		}
	}

	/**
	 * SQL Setup
	 */
	public function sql_setup() {
		global $wpdb;

		$old_version = get_option( 'ultimatemember_groups_db' );
		if ( um_groups_version === $old_version ) {
			return;
		}
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE {$this->db_groups_table} (
id int(11) unsigned NOT NULL auto_increment,
group_id int(11) unsigned NOT NULL,
user_id1 int(11) unsigned NOT NULL,
user_id2 int(11) unsigned NOT NULL,
status enum('pending_admin_review','pending_member_review','approved','rejected','blocked') NOT NULL,
role varchar(30) NOT NULL,
invites tinyint(1) unsigned NOT NULL DEFAULT 0,
time_stamp timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
date_joined_gmt timestamp NOT NULL,
PRIMARY KEY  (id)
) $charset_collate;";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $sql );

		// Modify table column for setting default CURRENT_TIMESTAMP only once
		if ( ! empty( $old_version ) && version_compare( '2.3.3', $old_version, '>=' ) ) {
			$wpdb->query(
				"ALTER TABLE {$this->db_groups_table}
				CHANGE date_joined
					date_joined TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP"
			);
		}

		/* >> Multisite todo */
		//      if ( is_multisite() && empty( $this->current_blog ) ) {
		//          $blogs = get_sites();
		//          foreach ( $blogs as $blog ) {
		//              if( $blog->deleted ){
		//                  continue;
		//              }
		//              switch_to_blog( $blog->blog_id );
		//              $this->current_blog = $blog;
		//              $this->db_groups_table = $wpdb->prefix . 'um_groups_members';
		//              $this->sql_setup();
		//          }
		//          restore_current_blog();
		//          $this->current_blog = null;
		//      } elseif ( isset( $this->current_blog ) ) {
		//          return;
		//      }
		/* << Multisite */

		update_option( 'ultimatemember_groups_db', um_groups_version );
	}


	/**
	 *
	 */
	public function run_setup() {
		$this->sql_setup();
		$this->set_default_settings();
		$this->force_show_create_pages();
	}
}
