<?php
namespace um_ext\um_groups\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Groups_Enqueue
 * @package um_ext\um_groups\core
 */
class Groups_Enqueue {

	/**
	 * Groups_Enqueue constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( &$this, 'public_enqueue_scripts' ) );
	}

	/**
	 * Enqueue
	 */
	public function public_enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();

		wp_register_script( 'um_scrollbar', um_groups_url . 'assets/libs/simplebar/simplebar' . $suffix . '.js', array( 'jquery' ), '4.0.0-alpha.5', true );
		wp_register_style( 'um_scrollbar', um_groups_url . 'assets/libs/simplebar/simplebar' . $suffix . '.css', array(), '4.0.0-alpha.5' );

		// public
		wp_register_script( 'um_groups', um_groups_url . 'assets/js/um-groups' . $suffix . '.js', array( 'um_scripts', 'jquery-ui-slider', 'um_members', 'um_scrollbar' ), um_groups_version, true );
		wp_set_script_translations( 'um_groups', um_groups_textdomain, um_groups_path . 'languages' );

		wp_register_script( 'um_autosize', um_groups_url . 'assets/libs/autosize/autosize' . $suffix . '.js', array( 'jquery' ), '6.0.1', true );
		wp_register_script( 'um_scrollto', um_groups_url . 'assets/libs/jquery.scrollTo/jquery.scrollTo' . $suffix . '.js', array( 'jquery' ), '2.1.3', true );

		wp_register_script( 'um_groups_discussion', um_groups_url . 'assets/js/um-groups-discussion' . $suffix . '.js', array( 'jquery-ui-autocomplete', 'um_fileupload', 'um_scripts', 'um_autosize', 'um_scrollto' ), um_groups_version, true );

		if ( is_rtl() ) {
			wp_register_style( 'um_groups_members_rtl', um_groups_url . 'assets/css/um-members-rtl' . $suffix . '.css', array(), um_groups_version );
			wp_register_style( 'um_groups_members', um_groups_url . 'assets/css/um-members' . $suffix . '.css', array( 'um_groups_members_rtl' ), um_groups_version );
		} else {
			wp_register_style( 'um_groups_members', um_groups_url . 'assets/css/um-members' . $suffix . '.css', array(), um_groups_version );
		}
		wp_register_style( 'um_groups', um_groups_url . 'assets/css/um-groups' . $suffix . '.css', array( 'um_ui', 'um_groups_members', 'um_scrollbar' ), um_groups_version );
		wp_register_style( 'um_groups_discussion', um_groups_url . 'assets/css/um-groups-discussion' . $suffix . '.css', array(), um_groups_version );

		if ( 'um_groups' === get_post_type() ) {
			wp_enqueue_script( 'um_groups' );
			wp_enqueue_style( 'um_groups' );
			wp_enqueue_script( 'um_groups_discussion' );
			wp_enqueue_style( 'um_groups_discussion' );
		}
	}
}
