<?php
namespace um_ext\um_groups\admin\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 *
 */
class Admin {

	/**
	 *
	 */
	public function __construct() {
		add_action( 'load-edit.php', array( &$this, 'posts_page' ) );
		add_action( 'load-post.php', array( &$this, 'add_edit_post' ) );
		add_action( 'load-post-new.php', array( &$this, 'add_edit_post' ) );

		add_action( 'um_admin_custom_register_metaboxes', array( &$this, 'add_metabox_register' ) );
	}

	/**
	 * Add metabox for the registration form.
	 */
	public function add_metabox_register() {
		if ( ! is_admin() || ! current_user_can( 'manage_options' ) ) {
			return;
		}

		add_meta_box(
			'um-admin-form-register-groups{' . um_groups_path . '}',
			__( 'Groups settings', 'um-groups' ),
			array( UM()->metabox(), 'load_metabox_form' ),
			'um_form',
			'side'
		);
	}

	public function posts_page() {
		if ( isset( $_GET['post_type'] ) && 'um_groups' === sanitize_key( $_GET['post_type'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts' ) );
		}
	}

	public function add_edit_post() {
		if ( ( isset( $_GET['post_type'] ) && 'um_groups' === sanitize_key( $_GET['post_type'] ) ) || ( isset( $_GET['post'] ) && 'um_groups' === get_post_type( absint( $_GET['post'] ) ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts' ) );
		}
	}

	/**
	 * @param $hook
	 */
	public function admin_enqueue_scripts( $hook ) {
		$suffix = UM()->admin()->enqueue()::get_suffix();

		$js_deps  = array( 'um_common', 'suggest' );
		$css_deps = array();
		if ( 'edit.php' !== $hook ) {
			wp_register_script( 'jquery-datatables', um_groups_url . 'assets/libs/jquery.dataTables/jquery.dataTables' . $suffix . '.js', array( 'jquery' ), '1.10.13', true );
			wp_register_style( 'jquery-datatables', um_groups_url . 'assets/libs/jquery.dataTables/jquery.dataTables' . $suffix . '.css', array(), '1.10.13' );
			$js_deps[]  = 'jquery-datatables';
			$css_deps[] = 'jquery-datatables';
		}

		wp_register_script( 'um_groups_admin', um_groups_url . 'assets/js/admin/um-groups' . $suffix . '.js', $js_deps, um_groups_version, true );
		wp_set_script_translations( 'um_groups_admin', um_groups_textdomain );
		wp_localize_script(
			'um_groups_admin',
			'um_groups_settings',
			array(
				'statuses' => UM()->Groups()->api()->get_member_statuses(),
				'roles'    => UM()->Groups()->api()->get_member_roles(),
			)
		);

		wp_register_style( 'um_groups_admin', um_groups_url . 'assets/css/admin/um-groups' . $suffix . '.css', $css_deps, um_groups_version );
		wp_enqueue_script( 'um_groups_admin' );
		wp_enqueue_style( 'um_groups_admin' );
	}
}
