<?php
/**
 * Template that displays a bar with a number of followers and following
 *
 * Call: UM()->Followers_API()->shortcode()->ultimatemember_followers_bar( $args )
 * Shortcode: [ultimatemember_followers_bar]
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-followers/bar.php
 *
 * @version 2.2.7
 *
 * @var $redirect
 * @var $can_follow
 * @var $followed
 * @var $user_id1
 * @var $user_id2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$content = '';
if ( ! is_user_logged_in() ) {
	$content = UM()->frontend()::layouts()::button(
		__( 'Follow', 'um-followers' ),
		array(
			'type'    => 'button',
			'size'    => 's',
			'classes' => array( 'um-login-to-follow-btn' ),
			'title'   => __( 'Follow', 'um-followers' ),
			'data'    => array(
				'redirect' => $redirect,
			),
		)
	);
} elseif ( $can_follow ) {
	if ( ! $followed ) {
		$content = UM()->frontend()::layouts()::button(
			__( 'Follow', 'um-followers' ),
			array(
				'type'    => 'button',
				'size'    => 's',
				'classes' => array( 'um-follow-btn' ),
				'title'   => __( 'Follow', 'um-followers' ),
				'data'    => array(
					'user_id' => $user_id1,
					'nonce'   => wp_create_nonce( 'um_followers_follow' . $user_id1 ),
				),
			)
		);
	} else {
		$unfollow_link = UM()->frontend()::layouts()::link(
			__( 'Unfollow', 'um-followers' ),
			array(
				'type'          => 'raw',
				'size'          => 's',
				'design'        => 'primary',
				'icon_position' => '',
				'title'         => __( 'Unfollow', 'um-followers' ),
				'classes'       => array(
					'um-unfollow-btn',
				),
				'data'          => array(
					'user_id' => $user_id1,
				),
			)
		);

		$content = UM()->frontend()::layouts()::dropdown_menu(
			'um-unfollow-request-btn',
			array(
				$unfollow_link,
			),
			array(
				'type'         => 'button',
				'button_label' => __( 'Following', 'um-followers' ),
				'width'        => 'toggle-button-width',
			)
		);
	}
}

echo wp_kses( $content, UM()->get_allowed_html( 'templates' ) );
