<?php
/**
 * Template for the UM Followers. The list of user following
 *
 * Shortcode: [ultimatemember_following]
 * Caller: method Followers_Shortcode->ultimatemember_following()
 *
 * @version 2.2.8
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-followers/following.php
 * @var array $following
 * @var int   $user_id
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! empty( $following ) ) {
	foreach ( $following as $k => $user_id1 ) {
		um_fetch_user( $user_id1 );
		?>
		<div class="um-followers-user">
			<a href="<?php echo esc_url( um_user_profile_url() ); ?>" class="um-followers-user-photo" title="<?php echo esc_attr( um_user( 'display_name' ) ); ?>">
				<?php echo get_avatar( $user_id1, 50 ); ?>
			</a>

			<div class="um-followers-user-name">
				<a href="<?php echo esc_url( um_user_profile_url() ); ?>" title="<?php echo esc_attr( um_user( 'display_name' ) ); ?>">
					<?php echo esc_html( um_user( 'display_name' ) ); ?>
				</a>

				<?php
				do_action( 'um_following_list_post_user_name', $user_id, $user_id1 );

				if ( get_current_user_id() === $user_id1 ) {
					?>
					<span class="um-followers-user-span"><?php esc_html_e( 'You', 'um-followers' ); ?></span>
					<?php
				} elseif ( UM()->Followers_API()->api()->followed( get_current_user_id(), $user_id1 ) ) {
					?>
					<span class="um-followers-user-span"><?php esc_html_e( 'Follows you', 'um-followers' ); ?></span>
					<?php
				}

				do_action( 'um_following_list_after_user_name', $user_id, $user_id1 );
				?>
			</div>

			<div class="um-followers-user-btn">
				<?php
				if ( get_current_user_id() === $user_id1 ) {
					echo '<a href="' . esc_url( um_edit_profile_url() ) . '" class="um-follow-edit um-button um-alt">' . esc_html__( 'Edit profile', 'um-followers' ) . '</a>';
				} else {
					echo wp_kses( UM()->Followers_API()->api()->follow_button( $user_id1, get_current_user_id() ), UM()->get_allowed_html( 'templates' ) );
				}
				?>
			</div>

			<?php do_action( 'um_following_list_pre_user_bio', $user_id, $user_id1 ); ?>

			<div class="um-followers-user-bio">
				<?php echo wp_kses( um_get_snippet( um_filtered_value( 'description' ), 25 ), UM()->get_allowed_html( 'templates' ) ); ?>
			</div>

			<?php do_action( 'um_following_list_post_user_bio', $user_id, $user_id1 ); ?>
		</div>
		<?php
	}
} else {
	?>
	<div class="um-profile-note">
		<span>
			<?php
			if ( get_current_user_id() === $user_id ) {
				esc_html_e( 'You did not follow anybody yet.', 'um-followers' );
			} else {
				esc_html_e( 'This user did not follow anybody yet.', 'um-followers' );
			}
			?>
		</span>
	</div>
	<?php
}
