<?php
/**
 * Template for the UM Followers. The list of user followers
 *
 * Shortcode: [ultimatemember_followers]
 * Caller: method Followers_Shortcode->ultimatemember_followers()
 *
 * @version 2.2.8
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-followers/followers.php
 *
 * @var array $followers
 * @var int   $user_id
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! empty( $followers ) ) {
	foreach ( $followers as $k => $user_id2 ) {
		um_fetch_user( $user_id2 );
		?>
		<div class="um-followers-user">
			<a href="<?php echo esc_url( um_user_profile_url() ); ?>" class="um-followers-user-photo" title="<?php echo esc_attr( um_user( 'display_name' ) ); ?>">
				<?php echo get_avatar( um_user( 'ID' ), 50 ); ?>
			</a>

			<div class="um-followers-user-btn">
				<?php
				if ( get_current_user_id() === $user_id2 ) {
					echo '<a href="' . esc_url( um_edit_profile_url() ) . '" class="um-follow-edit um-button um-alt">' . esc_html__( 'Edit profile', 'um-followers' ) . '</a>';
				} else {
					echo wp_kses( UM()->Followers_API()->api()->follow_button( $user_id2, get_current_user_id() ), UM()->get_allowed_html( 'templates' ) );
				}
				?>
			</div>

			<div class="um-followers-user-name">
				<a href="<?php echo esc_url( um_user_profile_url() ); ?>" title="<?php echo esc_attr( um_user( 'display_name' ) ); ?>">
					<?php echo esc_html( um_user( 'display_name' ) ); ?>
				</a>

				<?php
				do_action( 'um_followers_list_post_user_name', $user_id, $user_id2 );

				if ( get_current_user_id() === $user_id2 ) {
					?>
					<span class="um-followers-user-span"><?php esc_html_e( 'You', 'um-followers' ); ?></span>
				<?php } elseif ( get_current_user_id() === $user_id && UM()->Followers_API()->api()->followed( get_current_user_id(), $user_id2 ) ) { ?>
					<span class="um-followers-user-span"><?php esc_html_e( 'Follows you', 'um-followers' ); ?></span>
					<?php
				}

				do_action( 'um_followers_list_after_user_name', $user_id, $user_id2 );
				?>
			</div>

			<?php do_action( 'um_followers_list_pre_user_bio', $user_id, $user_id2 ); ?>

			<div class="um-followers-user-bio">
				<?php echo wp_kses( um_get_snippet( um_filtered_value( 'description' ), 25 ), UM()->get_allowed_html( 'templates' ) ); ?>
			</div>

			<?php do_action( 'um_followers_list_post_user_bio', $user_id, $user_id2 ); ?>
		</div>
		<?php
	}
} else {
	?>
	<div class="um-profile-note">
		<span>
			<?php
			if ( get_current_user_id() === $user_id ) {
				esc_html_e( 'You do not have any followers yet.', 'um-followers' );
			} else {
				esc_html_e( 'This user do not have any followers yet.', 'um-followers' );
			}
			?>
		</span>
	</div>
	<?php
}
