<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Extend settings
 *
 * @param $settings
 *
 * @return mixed
 */
function um_followers_settings( $settings ) {
	$settings['extensions']['sections']['followers'] = array(
		'title'  => __( 'Followers', 'um-followers' ),
		'fields' => array(
			array(
				'id'    => 'followers_show_stats',
				'type'  => 'checkbox',
				'label' => __( 'Show followers stats in member directory', 'um-followers' ),
			),
			array(
				'id'    => 'followers_show_button',
				'type'  => 'checkbox',
				'label' => __( 'Show follow button in member directory', 'um-followers' ),
			),
			array(
				'id'      => 'followers_allow_admin_to_follow',
				'type'    => 'checkbox',
				'label'   => __( 'Allow Administrators to follow users', 'um-followers' ),
				'tooltip' => __( 'Displays Follow buttons in profiles & member directory', 'um-followers' ),
			),
		),
	);

	return $settings;
}
add_filter( 'um_settings_structure', 'um_followers_settings' );


/**
 * Extends activity settings
 * @param $settings
 * @param $key
 *
 * @return mixed
 */
function um_followers_activity_settings( $settings, $key ) {
	$settings['extensions']['sections'][ $key ]['fields'] = array_merge(
		$settings['extensions']['sections'][ $key ]['fields'],
		array(
			array(
				'id'    => 'activity_followers_mention',
				'type'  => 'checkbox',
				'label' => __( 'Enable integration with followers to convert user names to user profile links automatically (mention users)?', 'um-followers' ),
			),
			array(
				'id'    => 'activity_followed_users',
				'type'  => 'checkbox',
				'label' => __( 'Show only followed users activity in the social wall', 'um-followers' ),
			),
		)
	);

	return $settings;
}
add_filter( 'um_activity_settings_structure', 'um_followers_activity_settings', 10, 2 );


/**
 * Extends email notifications settings
 *
 * @param $email_notifications
 *
 * @return mixed
 */
function um_followers_email_notifications( $email_notifications ) {
	$email_notifications['new_follower'] = array(
		'key'               => 'new_follower',
		'title'             => __( 'New Follower Notification', 'um-followers' ),
		'subject'           => '{follower} is now following you on {site_name}!',
		'body'              => 'Hi {followed},<br /><br />' .
		                       '{follower} has just followed you on {site_name}.<br /><br />' .
		                       'View his/her profile:<br />' .
		                       '{follower_profile}<br /><br />' .
		                       'Click on the following link to see your followers:<br />' .
		                       '{followers_url}<br /><br />' .
		                       'This is an automated notification from {site_name}. You do not need to reply.',
		'description'       => __( 'Send a notification to user when he receives a new review', 'um-followers' ),
		'recipient'         => 'user',
		'default_active'    => true
	);

	return $email_notifications;
}
add_filter( 'um_email_notifications', 'um_followers_email_notifications', 10, 1 );


/**
 * Adds a notification type
 *
 * @param array $logs
 *
 * @return array
 */
function um_followers_add_notification_type( $logs ) {
	$logs['new_follow'] = array(
		'title'         => __( 'User get followed by a person', 'um-followers' ),
		'account_desc'  => __( 'When someone follows me', 'um-followers' ),
	);

	return $logs;
}
add_filter( 'um_notifications_core_log_types', 'um_followers_add_notification_type', 200 );


/**
 * Adds a notification icon
 *
 * @param $output
 * @param $type
 *
 * @return string
 */
function um_followers_add_notification_icon( $output, $type ) {
	if ( $type == 'new_follow' ) {
		$output = '<i class="um-icon-android-person-add" style="color: #44b0ec"></i>';
	}
	return $output;
}
add_filter( 'um_notifications_get_icon', 'um_followers_add_notification_icon', 10, 2 );


/**
 * Extends wall privacy settings
 *
 * @param $array
 * @return mixed
 */
function um_followers_activity_wall_privacy_dropdown_values( $array ) {
	$array[3] = __( 'Followers', 'um-followers' );
	$array[4] = __( 'People I follow', 'um-followers' );

	return $array;
}
add_filter( 'um_activity_wall_privacy_dropdown_values', 'um_followers_activity_wall_privacy_dropdown_values', 10, 1 );


/**
 * Scan templates from extension
 *
 * @param $scan_files
 *
 * @return array
 */
function um_followers_extend_scan_files( $scan_files ) {
	$extension_files['um-followers'] = UM()->admin_settings()->scan_template_files( um_followers_path . '/templates/' );
	$scan_files                      = array_merge( $scan_files, $extension_files );

	return $scan_files;
}
add_filter( 'um_override_templates_scan_files', 'um_followers_extend_scan_files', 10, 1 );


/**
 * Get template paths
 *
 * @param $located
 * @param $file
 *
 * @return array
 */
function um_followers_get_path_template( $located, $file ) {
	if ( file_exists( get_stylesheet_directory() . '/ultimate-member/um-followers/' . $file ) ) {
		$located = array(
			'theme' => get_stylesheet_directory() . '/ultimate-member/um-followers/' . $file,
			'core'  => um_followers_path . 'templates/' . $file,
		);
	}

	return $located;
}
add_filter( 'um_override_templates_get_template_path__um-followers', 'um_followers_get_path_template', 10, 2 );
