<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter user permissions in Followers
 *
 * @param array $meta
 *
 * @return array
 */
function um_followers_user_permissions_filter( $meta ) {
	if ( ! isset( $meta['can_follow'] ) ) {
		$meta['can_follow'] = 1;
	}

	return $meta;
}
add_filter( 'um_user_permissions_filter', 'um_followers_user_permissions_filter' );

/**
 * Filter for Groups invites
 *
 * @param array $options
 *
 * @return array
 */
function um_followers_groups_invite_people( $options ) {
	$options['followers'] = __( 'Followers only', 'um-followers' );
	return $options;
}
add_filter( 'um_groups_invite_people', 'um_followers_groups_invite_people' );

/**
 * Creates options in Role page
 *
 * @param $roles_metaboxes
 *
 * @return array
 */
function um_followers_add_role_metabox( $roles_metaboxes ) {
	$roles_metaboxes[] = array(
		'id'       => 'um-admin-form-followers{' . um_followers_path . '}',
		'title'    => __( 'Followers', 'um-followers' ),
		'callback' => array( UM()->metabox(), 'load_metabox_role' ),
		'screen'   => 'um_role_meta',
		'context'  => 'normal',
		'priority' => 'default',
	);

	return $roles_metaboxes;
}
add_filter( 'um_admin_role_metaboxes', 'um_followers_add_role_metabox', 10, 1 );

/**
 * Add options for field's privacy
 *
 * @param array $options
 *
 * @return array
 */
function um_followers_privacy_options( $options ) {
	$options['-5'] = __( 'Only followers', 'um-followers' );

	// check if there is 'only friends' option
	if ( isset( $options['-4'] ) ) {
		$options['-6'] = __( 'Only friends and followers', 'um-followers' );
	}

	return $options;
}
add_filter( 'um_field_privacy_options', 'um_followers_privacy_options' );

///**
// * Add any custom links to plugin page.
// *
// * @param array $links
// *
// * @return array
// */
//function um_followers_plugin_links( $links ) {
//	$more_links[] = '<a href="' . admin_url() . 'admin.php?page=um_options&tab=extensions">' . esc_html__( 'Settings', 'um-followers' ) . '</a>';
//	return $more_links + $links;
//}
//$prefix = is_network_admin() ? 'network_admin_' : '';
//add_filter( "{$prefix}plugin_action_links_" . um_followers_plugin, 'um_followers_plugin_links' );
