<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @param array    $query_args
 * @param int      $user_id
 * @param null|int $wall_id
 * @param array    $metarows
 *
 * @return array
 */
function um_followers_user_notes_activity_query_privacy( $query_args, $user_id, $wall_id, $metarows ) {
	if ( empty( $user_id ) || ! empty( $wall_id ) ) {
		return $query_args;
	}

	if ( in_array( 'follower', $metarows, true ) ) {
		$following = UM()->Followers_API()->api()->following( $user_id ); // People followed by user ID.
		$following = ! empty( $following ) ? array_merge( $following, array( $user_id ) ) : array( $user_id );
		$following = array_unique( $following );
		if ( ! empty( $following ) ) {
			$query_args[] = array(
				'relation' => 'AND',
				array(
					'key'     => 'um_note_privacy',
					'value'   => 'follower',
					'compare' => '=',
				),
				array(
					'key'     => '_wall_id',
					'value'   => $following,
					'compare' => 'IN',
				),
			);
		}
	}

	if ( in_array( 'followed', $metarows, true ) ) {
		$followers = UM()->Followers_API()->api()->followers( $user_id ); // People who follow user ID.
		$followers = ! empty( $followers ) ? array_merge( $followers, array( $user_id ) ) : array( $user_id );
		$followers = array_unique( $followers );
		if ( ! empty( $followers ) ) {
			$query_args[] = array(
				'relation' => 'AND',
				array(
					'key'     => 'um_note_privacy',
					'value'   => 'followed',
					'compare' => '=',
				),
				array(
					'key'     => '_wall_id',
					'value'   => $followers,
					'compare' => 'IN',
				),
			);
		}
	}

	return $query_args;
}
add_filter( 'um_user_notes_activity_query_privacy', 'um_followers_user_notes_activity_query_privacy', 10, 4 );

/**
 * @param array    $query_args
 * @param int      $user_id
 * @param null|int $wall_id
 * @param array    $metarows
 *
 * @return array
 */
function um_followers_user_photos_activity_query_privacy( $query_args, $user_id, $wall_id, $metarows ) {
	if ( empty( $user_id ) || ! empty( $wall_id ) ) {
		return $query_args;
	}

	if ( in_array( 'follower', $metarows, true ) ) {
		$following = UM()->Followers_API()->api()->following( $user_id ); // People followed by user ID.
		$following = ! empty( $following ) ? array_merge( $following, array( $user_id ) ) : array( $user_id );
		$following = array_unique( $following );
		if ( ! empty( $following ) ) {
			$query_args[] = array(
				'relation' => 'AND',
				array(
					'key'     => 'um_user_photos_privacy',
					'value'   => 'follower',
					'compare' => '=',
				),
				array(
					'key'     => '_wall_id',
					'value'   => $following,
					'compare' => 'IN',
				),
			);
		}
	}

	if ( in_array( 'followed', $metarows, true ) ) {
		$followers = UM()->Followers_API()->api()->followers( $user_id ); // People who follow user ID.
		$followers = ! empty( $followers ) ? array_merge( $followers, array( $user_id ) ) : array( $user_id );
		$followers = array_unique( $followers );
		if ( ! empty( $followers ) ) {
			$query_args[] = array(
				'relation' => 'AND',
				array(
					'key'     => 'um_user_photos_privacy',
					'value'   => 'followed',
					'compare' => '=',
				),
				array(
					'key'     => '_wall_id',
					'value'   => $followers,
					'compare' => 'IN',
				),
			);
		}
	}

	return $query_args;
}
add_filter( 'um_user_photos_activity_query_privacy', 'um_followers_user_photos_activity_query_privacy', 10, 4 );


function um_followers_user_photos_activity_post_can_view( $can_view, $post_id ) {
	if ( ! $can_view ) {
		return $can_view;
	}

	$photos_privacy = get_post_meta( $post_id, 'um_user_photos_privacy', true );
	if ( ( 'follower' === $photos_privacy || 'followed' === $photos_privacy ) && ! is_user_logged_in() ) {
		return false;
	}

	$wall_id = UM()->Activity_API()->api()->get_wall( $post_id );
	if ( absint( $wall_id ) === get_current_user_id() ) {
		return $can_view;
	}

	if ( 'follower' === $photos_privacy ) {
		$following = UM()->Followers_API()->api()->following( get_current_user_id() );
		if ( empty( $following ) || ! is_array( $following ) || ! in_array( absint( $wall_id ), array_map( 'absint', $following ), true ) ) {
			return false;
		}
	} elseif ( 'followed' === $photos_privacy ) {
		$following = UM()->Followers_API()->api()->followers( get_current_user_id() );
		if ( empty( $following ) || ! is_array( $following ) || ! in_array( absint( $wall_id ), array_map( 'absint', $following ), true ) ) {
			return false;
		}
	}

	return $can_view;
}
add_filter( 'um_user_photos_activity_post_can_view', 'um_followers_user_photos_activity_post_can_view', 10, 2 );

function um_followers_user_notes_activity_post_can_view( $can_view, $post_id ) {
	if ( ! $can_view ) {
		return $can_view;
	}

	$notes_privacy = get_post_meta( $post_id, 'um_note_privacy', true );
	if ( ( 'follower' === $notes_privacy || 'followed' === $notes_privacy ) && ! is_user_logged_in() ) {
		return false;
	}

	$wall_id = UM()->Activity_API()->api()->get_wall( $post_id );
	if ( absint( $wall_id ) === get_current_user_id() ) {
		return $can_view;
	}

	if ( 'follower' === $notes_privacy ) {
		$following = UM()->Followers_API()->api()->following( get_current_user_id() );
		if ( empty( $following ) || ! is_array( $following ) || ! in_array( absint( $wall_id ), array_map( 'absint', $following ), true ) ) {
			return false;
		}
	} elseif ( 'followed' === $notes_privacy ) {
		$following = UM()->Followers_API()->api()->followers( get_current_user_id() );
		if ( empty( $following ) || ! is_array( $following ) || ! in_array( absint( $wall_id ), array_map( 'absint', $following ), true ) ) {
			return false;
		}
	}

	return $can_view;
}
add_filter( 'um_user_notes_activity_post_can_view', 'um_followers_user_notes_activity_post_can_view', 10, 2 );

/**
 * @param array    $privacy_array
 * @param int      $user_id
 * @param null|int $wall_id
 * @param array    $metarows
 *
 * @return array
 */
function um_followers_user_photos_notes_activity_query_privacy_array( $privacy_array, $user_id, $wall_id, $metarows ) {
	if ( empty( $user_id ) || empty( $wall_id ) ) {
		return $privacy_array;
	}

	if ( in_array( 'follower', $metarows, true ) ) {
		if ( UM()->Followers_API()->api()->followed( $wall_id, $user_id ) ) {
			$privacy_array[] = 'follower';
		}
	}

	if ( in_array( 'followed', $metarows, true ) ) {
		if ( UM()->Followers_API()->api()->followed( $user_id, $wall_id ) ) {
			$privacy_array[] = 'followed';
		}
	}

	return $privacy_array;
}
add_filter( 'um_user_photos_activity_query_privacy_array', 'um_followers_user_photos_notes_activity_query_privacy_array', 10, 4 );
add_filter( 'um_user_notes_activity_query_privacy_array', 'um_followers_user_photos_notes_activity_query_privacy_array', 10, 4 );
