<?php
namespace um_ext\um_followers\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Followers_Enqueue
 * @package um_ext\um_followers\core
 */
class Followers_Enqueue {

	/**
	 * Followers_Enqueue constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( &$this, 'wp_enqueue_scripts' ), 9999 );
		add_action( 'um_enqueue_frontend_preview_assets', array( &$this, 'frontend_preview_assets' ) );
		add_action( 'enqueue_block_assets', array( &$this, 'frontend_preview_assets' ), 11 );
	}

	/**
	 *
	 */
	public function wp_enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();

		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			wp_register_script( 'um_followers', um_followers_url . 'assets/js/v3/followers' . $suffix . '.js', array( 'um_new_design' ), um_followers_version, true );
			wp_register_style( 'um_followers', um_followers_url . 'assets/css/v3/followers' . $suffix . '.css', array( 'um_new_design' ), um_followers_version );
		} else {
			wp_register_script( 'um_followers', um_followers_url . 'assets/js/um-followers' . $suffix . '.js', array( 'jquery', 'wp-util', 'um_scripts' ), um_followers_version, true );
			wp_register_style( 'um_followers', um_followers_url . 'assets/css/um-followers' . $suffix . '.css', array( 'um_fonticons_ii', 'um_fonticons_fa' ), um_followers_version );
		}
	}

	/**
	 *
	 */
	public function frontend_preview_assets() {
		$suffix = UM()->admin()->enqueue()::get_suffix();
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			wp_register_style( 'um_followers', um_followers_url . 'assets/css/v3/followers' . $suffix . '.css', array( 'um_new_design' ), um_followers_version );
		} else {
			wp_register_style( 'um_followers', um_followers_url . 'assets/css/um-followers' . $suffix . '.css', array( 'um_fonticons_ii', 'um_fonticons_fa' ), um_followers_version );
		}
		wp_enqueue_style( 'um_followers' );
	}
}
