<?php
namespace um_ext\um_followers\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Followers_Account
 * @package um_ext\um_friends\core
 */
class Followers_Account {

	/**
	 * Followers_Account constructor.
	 */
	public function __construct() {
		add_action( 'um_post_account_update', array( &$this, 'account_update' ) );

		add_filter( 'um_account_page_default_tabs_hook', array( &$this, 'account_notification_tab' ) );
		add_filter( 'um_account_content_hook_notifications', array( &$this, 'account_tab' ), 49, 2 );
		add_filter( 'um_account_notifications_tab_enabled', '__return_true' );

		add_filter( 'um_predefined_fields_hook', array( &$this, 'predefined_fields_hook' ), 10 );
		add_filter( 'um_account_tab_notifications_fields', array( &$this, 'add_notifications_fields' ), 10 );
	}

	/**
	 * Update Account action
	 */
	public function account_update() {
		/**
		 * issue helpscout#31301
		 */
		$current_tab = isset( $_POST['_um_account_tab'] ) ? sanitize_key( $_POST['_um_account_tab'] ) : null;
		if ( 'notifications' !== $current_tab ) {
			return;
		}

		$user_id = um_user( 'ID' );

		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			if ( isset( $_POST['_enable_new_follow'] ) ) {
				update_user_meta( $user_id, '_enable_new_follow', true );
			} else {
				update_user_meta( $user_id, '_enable_new_follow', false );
			}
		} else {
			if ( isset( $_POST['_enable_new_follow'] ) ) {
				update_user_meta( $user_id, '_enable_new_follow', 'yes' );
			} else {
				update_user_meta( $user_id, '_enable_new_follow', 'no' );
			}
		}
	}

	/**
	 * Add Notifications tab to account page
	 *
	 * @param array $tabs
	 * @return array
	 */
	public function account_notification_tab( $tabs ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			return $tabs;
		}

		if ( empty( $tabs[400]['notifications'] ) ) {
			$tabs[400]['notifications'] = array(
				'icon'         => 'um-faicon-envelope',
				'title'        => __( 'Notifications', 'um-followers' ),
				'submit_title' => __( 'Update Notifications', 'um-followers' ),
			);
		}

		return $tabs;
	}

	public function account_tab( $output, $shortcode_args ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			return $output;
		}

		if ( ! UM()->options()->get( 'new_follower_on' ) ) {
			return $output;
		}

		if ( isset( $shortcode_args['_enable_new_follow'] ) && 0 == $shortcode_args['_enable_new_follow'] ) {
			return $output;
		}

		UM()->account()->add_displayed_field( '_enable_new_follow', 'notifications' );

		$_enable_new_follow = UM()->Followers_API()->api()->enabled_email( get_current_user_id() );

		$t_args  = compact( '_enable_new_follow' );
		$output .= UM()->get_template( 'account-notifications.php', um_followers_plugin, $t_args );

		return $output;
	}

	public function predefined_fields_hook( $fields ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			$fields['_enable_new_follow'] = array(
				'title'                    => __( 'I\'m followed by someone new', 'ultimate-member' ),
				'metakey'                  => '_enable_new_follow',
				'type'                     => 'bool',
				'checkbox_label'           => __( 'I\'m followed by someone new', 'um-followers' ),
				'checkbox_label_supported' => __( 'I\'m followed by someone new', 'um-followers' ),
				'required'                 => 0,
				'public'                   => 1,
				'editable'                 => true,
				'default'                  => UM()->options()->get( 'new_follower_on' ) ? true : false,
				'account_only'             => true,
				'required_opt'             => array( 'new_follower_on', '1' ),
			);

//			$fields['followers_divider'] = array(
//				'title'          => __( 'I\'m followed by someone new', 'ultimate-member' ),
//				'type'           => 'block',
//				'content'        => __( 'Followers', 'um-followers' ),
//				'label'          => __( 'I\'m followed by someone new', 'um-followers' ),
//				'public'         => 1,
//				'account_only'   => true,
//				'required_opt'   => array( 'new_follower_on', '1' ),
//			);

			if ( UM()->options()->get( 'new_follower_on' ) ) {
				UM()->account()->add_displayed_field( '_enable_new_follow', 'notifications' );
				// UM()->account()->add_displayed_field( 'followers_divider', 'notifications' );
			}
		}
		return $fields;
	}

	public function add_notifications_fields( $fields ) {
		if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
			//$fields .= 'followers_divider,_enable_new_follow';
			$fields .= ',_enable_new_follow';
		}

		return $fields;
	}
}
