<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add "follows you" if the user is following current user.
 * @todo find the proper place for following state in new UI.
 */
function um_followers_add_state( $args, $user_id = null ) {
	if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
		return;
	}

	if ( ! is_user_logged_in() ) {
		return;
	}

	if ( ! $user_id ) {
		$user_id = um_profile_id();
	}

	if ( get_current_user_id() === absint( $user_id ) ) {
		return;
	}

	if ( UM()->Followers_API()->api()->followed( get_current_user_id(), $user_id ) ) {
		wp_enqueue_style( 'um_followers' );
		wp_enqueue_script( 'um_followers' );

		echo '<span class="um-follows-you">' . esc_html__( 'follows you', 'um-followers' ) . '</span>';
	}
}
add_action( 'um_after_profile_name_inline', 'um_followers_add_state', 200, 2 );

/**
 * Followers List.
 */
function um_profile_content_followers() {
	echo wp_kses( apply_shortcodes( '[ultimatemember_followers user_id="' . um_profile_id() . '" /]' ), UM()->get_allowed_html( 'templates' ) );
}
if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
	add_action( 'um_profile_content_followers', 'um_profile_content_followers' );
} else {
	add_action( 'um_profile_content_followers_default', 'um_profile_content_followers' );
}
/**
 * Following List.
 *
 */
function um_profile_content_following() {
	echo wp_kses( apply_shortcodes( '[ultimatemember_following user_id="' . um_profile_id() . '" /]' ), UM()->get_allowed_html( 'templates' ) );
}
if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
	add_action( 'um_profile_content_following', 'um_profile_content_following' );
} else {
	add_action( 'um_profile_content_following_default', 'um_profile_content_following' );
}

if ( defined( 'UM_DEV_MODE' ) && UM_DEV_MODE && UM()->options()->get( 'enable_new_ui' ) ) {
	/**
	 * Customize the nav bar.
	 * @todo find the best place in new UI.
	 */
	function um_followers_add_profile_bar( $args, $user_id, &$index ) {
		$content = UM()->Followers_API()->api()->follow_button( $user_id, get_current_user_id() );
		if ( ! empty( $content ) ) {
			++$index;
			echo wp_kses( $content, UM()->get_allowed_html( 'templates' ) );
		}
	}
	add_action( 'um_profile_navbar_content', 'um_followers_add_profile_bar', 4, 3 );
} else {
	/**
	 * Customize the nav bar.
	 * @todo find the best place in new UI.
	 */
	function um_followers_add_profile_bar() {
		echo wp_kses( apply_shortcodes( '[ultimatemember_followers_bar user_id="' . um_profile_id() . '" /]' ), UM()->get_allowed_html( 'templates' ) );
	}
	add_action( 'um_profile_navbar', 'um_followers_add_profile_bar', 4 );
}

/**
 * User suggestions for Social Activity.
 *
 * @param array  $data
 * @param string $term
 *
 * @return array
 */
function um_followers_ajax_get_user_suggestions( $data, $term ) {
	if ( ! UM()->options()->get( 'activity_followers_mention' ) ) {
		return $data;
	}

	$term = str_replace( '@', '', $term );
	if ( empty( $term ) ) {
		return $data;
	}

	$users_data = array();

	$following = UM()->Followers_API()->api()->following( get_current_user_id() );
	if ( $following ) {
		foreach ( $following as $user_id ) {
			$mentioned_data = um_followers_fetch_mentioned_user( $user_id, $term );
			if ( false === $mentioned_data ) {
				continue;
			}

			$users_data[] = $mentioned_data;
		}
	}

	$followers = UM()->Followers_API()->api()->followers( get_current_user_id() );
	if ( $followers ) {
		foreach ( $followers as $user_id ) {
			$mentioned_data = um_followers_fetch_mentioned_user( $user_id, $term );
			if ( false === $mentioned_data ) {
				continue;
			}

			$users_data[] = $mentioned_data;
		}
	}

	if ( ! empty( $users_data ) ) {
		$users_data = array_merge( ...$users_data );
		$data       = array_merge( $data, $users_data );
	}

	return $data;
}
add_filter( 'um_activity_ajax_get_user_suggestions', 'um_followers_ajax_get_user_suggestions', 10, 2 );

function um_followers_fetch_mentioned_user( $user_id, $term ) {
	um_fetch_user( $user_id );

	$start = mb_stripos( um_user( 'display_name' ), $term );
	if ( false === $start ) {
		return false;
	}
	$find_length = mb_strlen( $term );

	$first_sub  = mb_substr( um_user( 'display_name' ), 0, $start );
	$second_sub = mb_substr( um_user( 'display_name' ), $start, $find_length );
	$third_sub  = mb_substr( um_user( 'display_name' ), $start + $find_length );
	$name       = $first_sub . '<strong>' . $second_sub . '</strong>' . $third_sub;

	$users_data             = array();
	$users_data[ $user_id ] = array(
		'user_id'  => $user_id,
		'photo'    => get_avatar( $user_id, 80 ),
		'name'     => $name,
		'username' => um_user( 'display_name' ),
	);

	return $users_data;
}
