<?php
/**
 * Plugin Name: WooCommerce RTM Custom Emails
 * Description: Plugin to add any custom emails required for the Taalthuis application.
 * Author: RTM Business
 * Version: 0.1
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 *  Add a custom email to the list of emails WooCommerce should load
 *
 * @param array $email_classes available email classes
 * @return array filtered available email classes
 * @since 0.1
 */
function rtm_add_custom_woocommerce_emails($email_classes)
{
    // include our custom email classes
    require_once('includes/class-wc-customer-new-order-email.php');
    require_once('includes/class-wc-customer-bank-reminder-email.php');
    require_once('includes/class-wc-customer-on-hold-order-no-pdf.php');
    require_once('includes/class-wc-customer-processing-order-no-pdf.php');
    require_once('includes/class-wc-customer-course-changed.php');


    // add the email classes to the list of email classes that WooCommerce loads
    $email_classes['WC_Email_Customer_New_Order'] = new WC_Email_Customer_New_Order();
    $email_classes['WC_Email_Customer_Bank_Reminder'] = new WC_Email_Customer_Bank_Reminder();
    $email_classes['WC_Email_On_Hold_Order_No_PDF'] = new WC_Email_On_Hold_Order_No_PDF();
    $email_classes['WC_Email_Processing_Order_No_PDF'] = new WC_Email_Processing_Order_No_PDF();
    $email_classes['WC_Email_Customer_Course_Changed'] = new WC_Email_Customer_Course_Changed();

    return $email_classes;

}

function rtm_add_custom_woocommerce_actions($email_actions)
{
    $email_actions[] = 'woocommerce_checkout_order_processed';

    return $email_actions;
}

/**
 * Add action to order actions meta box.
 *
 * @return actions to be added to meta box.
 */
function add_order_meta_box_action($actions)
{

    $actions['send_bank_reminder_email'] = __('Send bank reminder email', 'woocommerce');
    return $actions;
}


/**
 * Trigger the sending of this email.
 *
 */
function handle_order_meta_box_action($order)
{

    WC()->payment_gateways();
    WC()->shipping();
    WC()->mailer()->emails['WC_Email_Customer_Bank_Reminder']->trigger($order->get_id(), $order);
}

add_action('woocommerce_order_actions', 'add_order_meta_box_action');
add_action('woocommerce_order_action_send_bank_reminder_email', 'handle_order_meta_box_action');
add_filter('woocommerce_email_classes', 'rtm_add_custom_woocommerce_emails');
add_filter('woocommerce_email_actions', 'rtm_add_custom_woocommerce_actions');


// wrap the email_order_meta output in kses, autop, texturize, do_shortcode
add_action('woocommerce_email_order_meta', 'start_wrap_email_order_meta', PHP_INT_MIN);
add_action('woocommerce_email_order_meta', 'end_wrap_email_order_meta', PHP_INT_MAX);

function start_wrap_email_order_meta()
{
    ob_start();
}

function end_wrap_email_order_meta()
{
    echo wp_kses_post(wpautop(wptexturize(do_shortcode(ob_get_clean()))));
    ob_end_flush();
}
