<?php

/**
 * Customer invoice email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-invoice.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<?php
/** @var WC_Order $order */
$order = $objects['order'];
$customer = $objects['customer'];
$product = $objects['product'];
$changes = $objects['changes'];
$product_name = $product->get_name();
$order_number = $order->get_order_number();

$email_text = <<<HTML
<p>Hello {$customer['first_name']},</p>

<p>The course "{$product_name}" you registered for (Order {$order_number}) was updated:</p>

<table style="border: 0; border-collapse: collapse;">
HTML;

foreach ($changes as $change_label => $change_value) {
	$email_text .= "<th scope='row'>{$change_label}</th><td>{$change_value}</td>";
}

$email_text .= <<< HTML
</table>
<p>We look forward to seeing you in the course!</p>
<p>Taalthuis team.</p>
HTML;

echo $email_text;

/**
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );
