<?php

/**
 * Customer invoice email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-invoice.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
echo "= " . $email_heading . " =\n\n";

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/** @var WC_Order $order */
$order = $objects['order'];
$customer = $objects['customer'];
$product = $objects['product'];
$changes = $objects['changes'];
$product_name = $product->get_name();
$order_number = $order->get_order_number();

$email_text = <<<PLAINTEXT
Hello {$customer['first_name']},

The course "{$product_name}" you registered for (Order {$order_number}) was updated:
PLAINTEXT;

foreach ($changes as $change_label => $change_value) {
	$email_text .= "{$change_label}:\t{$change_value}";
}

$email_text .= <<< PLAINTEXT
We look forward to seeing you in the course!

Taalthuis team.
PLAINTEXT;

echo $email_text;

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

echo apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) );
