<?php
/**
 * Plugin Name: RTM Filter WoooCommerce Orders by Product Meta Field
 * Plugin URI: http://www.rtmbusiness.nl/
 * Description: Filters WooCommerce orders by a product meta field
 * Author: RTM - Rik Zwarthoff
 * Author URI: http://www.rtmbusiness.nl/
 * Version: 1.0.0
 * Text Domain: wc-rtm-filter-orders-by-product-meta-field
 *
 *
 * @package   wc-rtm-filter-orders-by-product-meta-field
 * @author    RTM - Rik Zwarthoff
 * @category  Admin
 */

defined('ABSPATH') or exit;

// fire it up!
add_action('plugins_loaded', 'wc_filter_orders_by_payment');


/**
 * Main plugin class
 *
 * @since 1.0.0
 */
class WC_Filter_Orders_By_Payment
{
    const VERSION = '1.0.0';

    /** @var WC_Filter_Orders_By_Payment single instance of this plugin */
    protected static $instance;

    /**
     * Main plugin class constructor
     *
     * @since 1.0.0
     */
    public function __construct()
    {
        if (is_admin()) {

            // add bulk order filter for exported / non-exported orders
            add_action('restrict_manage_posts', array( $this, 'filter_orders_by_payment_method'), 20);


            add_filter('posts_where', array( $this, 'add_filterable_where' ));
        }
    }

    /** Plugin methods ***************************************/

    /**
     * Add bulk filter for orders by product meta field
     *
     * @since 1.0.0
     */
    public function filter_orders_by_payment_method() {
        global $typenow;
        global $wpdb;

			  if ('shop_order' === $typenow) {
            $original_products = $wpdb->get_results(
                      "SELECT p.ID, p.post_title
				 	            FROM {$wpdb->posts} p
				 	            LEFT JOIN wp_icl_translations icl
				 	            ON icl.element_id = p.ID
				 	            WHERE icl.language_code = 'en' 	   
				 	            AND p.post_type = 'product'
											GROUP BY p.ID
											ORDER BY p.ID DESC",
											ARRAY_N
                    );
									?>



			<select name="_rtm_order_product_meta_field" id="dropdown_rtm_order_product_meta_field">
				<option value="">
					<?php esc_html_e('All Courses', 'wc-rtm-filter-orders-by-product-meta-field'); ?>
				</option>

				<?php foreach ($original_products as $original_product) {

          $product_id = $original_product[0];
          $product_title = $original_product[1]; ?>

					<option value="<?php echo esc_attr($product_id); ?>" <?php echo esc_attr(isset($_GET['_rtm_order_product_meta_field']) ? selected($product_id, $_GET['_rtm_order_product_meta_field'], false) : ''); ?>>
						<?php echo esc_html($product_id); ?> - <?php echo esc_html($product_title); ?>
					</option>

				<?php
        } ?>
			</select>
			<?php
        }
    }

    /**
     * Modify SQL JOIN for filtering the orders by any coupons used
     *
     * @since 1.0.0
     *
     * @param string $join JOIN part of the sql query
     * @return string $join modified JOIN part of sql query
     */
    public function add_order_items_join($join)
    {
        global $typenow, $wpdb;
        if ('shop_order' === $typenow && isset($_GET['_rtm_order_product_meta_field']) && ! empty($_GET['_rtm_order_product_meta_field'])) {
            $join .= "LEFT JOIN {$wpdb->prefix}woocommerce_order_items woi ON {$wpdb->posts}.ID = woi.order_id LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta woim ON woim.order_item_id=woi.order_item_id";
        }
        return $join;
    }
    /**
     * Modify SQL WHERE for filtering the orders by any coupons used
     *
     * @since 1.0.0
     *
     * @param string $where WHERE part of the sql query
     * @return string $where modified WHERE part of sql query
     */
    public function add_filterable_where($where)
    {
        global $typenow, $wpdb;
        if ('shop_order' === $typenow && isset($_GET['_rtm_order_product_meta_field']) && ! empty($_GET['_rtm_order_product_meta_field'])) {
            // Main WHERE query part
            $value = wc_clean($_GET['_rtm_order_product_meta_field']);
            if (empty($value)) {
                return;
            }

            $t_posts = $wpdb->posts;
      			$t_order_items = $wpdb->prefix . "woocommerce_order_items";
      			$t_order_itemmeta = $wpdb->prefix . "woocommerce_order_itemmeta";


      				$product = $value;
      				$where .= " AND $product IN (SELECT $t_order_itemmeta.meta_value FROM $t_order_items LEFT JOIN $t_order_itemmeta on $t_order_itemmeta.order_item_id=$t_order_items.order_item_id WHERE $t_order_items.order_item_type='line_item' AND $t_order_itemmeta.meta_key='_product_id' AND $t_posts.ID=$t_order_items.order_id)";

        }
        return $where;
    }


    /** Helper methods ***************************************/


    /**
     * Main WC_Filter_Orders_By_Payment Instance, ensures only one instance is/can be loaded
     *
     * @since 1.0.0
     * @see wc_filter_orders_by_payment()
     * @return WC_Filter_Orders_By_Payment
    */
    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }
}


/**
 * Returns the One True Instance of WC_Filter_Orders_By_Payment
 *
 * @since 1.0.0
 * @return WC_Filter_Orders_By_Payment
 */
function wc_filter_orders_by_payment()
{
    return WC_Filter_Orders_By_Payment::instance();
}
