<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;

/**
 * Class FallbackVisibility
 */
class FallbackVisibility extends Singleton {

	const OPTION_NAME = 'fallback';

	/**
	 * FallbackVisibility constructor
	 */
	public function __construct() {
		parent::__construct();

		$this->register_elementor_settings( 'fallback_section' );
	}

	/**
	 * Register section
	 *
	 * @param $element
	 * @return void
	 */
	public function register_section( $element ) {
		$element->start_controls_section(
			self::SECTION_PREFIX . 'fallback_section',
			[
				'tab'       => self::VISIBILITY_TAB,
				'label'     => __( 'Fallback', 'visibility-logic-elementor-pro' ),
				'condition' => [
					self::SECTION_PREFIX . 'enabled' => 'yes',
				],
			]
		);

		$element->end_controls_section();
	}

	/**
	 * @param $element \Elementor\Widget_Base
	 * @param $section_id
	 * @param $args
	 */
	public function register_controls( $element, $args ) {
		$element->add_control(
			self::SECTION_PREFIX . 'fallback_enabled',
			[
				'label'          => __( 'Enable', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SWITCHER,
				'default'        => '',
				'description'    => __( 'Show something when the element is hidden.', 'visibility-logic-elementor-pro' ),
				'label_on'       => __( 'Yes', 'visibility-logic-elementor-pro' ),
				'label_off'      => __( 'No', 'visibility-logic-elementor-pro' ),
				'return_value'   => 'yes',
				'prefix_class'   => 'stax-fallback_enabled-',
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'fallback_type',
			[
				'label'          => __( 'Content type', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::CHOOSE,
				'options'        => [
					'text'     => [
						'title' => __( 'Text', 'visibility-logic-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'template' => [
						'title' => __( 'Template', 'visibility-logic-elementor-pro' ),
						'icon'  => 'fa fa-th-large',
					],
				],
				'default'        => 'text',
				'condition'      => [
					self::SECTION_PREFIX . 'fallback_enabled' => 'yes',
				],
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'fallback_template',
			[
				'label'          => __( 'Render Template', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SELECT2,
				'options'        => Helpers::get_all_template(),
				'description'    => __( 'Show an Elementor template when the element is hidden.', 'visibility-logic-elementor-pro' ),
				'condition'      => [
					self::SECTION_PREFIX . 'fallback_enabled' => 'yes',
					self::SECTION_PREFIX . 'fallback_type' => 'template',
				],
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'fallback_text',
			[
				'label'          => __( 'Text Fallback', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::WYSIWYG,
				'default'        => 'This element is currently hidden.',
				'description'    => __( 'Insert here some content showed if the element is not visible', 'visibility-logic-elementor-pro' ),
				'condition'      => [
					self::SECTION_PREFIX . 'fallback_enabled' => 'yes',
					self::SECTION_PREFIX . 'fallback_type' => 'text',
				],
				'style_transfer' => false,
			]
		);
	}

}

FallbackVisibility::instance();
