<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;

/**
 * Class ConditionalTagsVisibility
 */
class ConditionalTagsVisibility extends Singleton {

	const OPTION_NAME = 'conditional-tags';

	/**
	 * ConditionalTagsVisibility constructor
	 */
	public function __construct() {
		parent::__construct();

		$this->register_elementor_settings( 'conditional_tags_section' );

		add_filter( 'stax/visibility/apply_conditions', [ $this, 'apply_conditions' ], 10, 3 );
	}

	/**
	 * Register section
	 *
	 * @param $element
	 * @return void
	 */
	public function register_section( $element ) {
		$element->start_controls_section(
			self::SECTION_PREFIX . 'conditional_tags_section',
			[
				'tab'       => self::VISIBILITY_TAB,
				'label'     => __( 'Conditional Tags', 'visibility-logic-elementor-pro' ),
				'condition' => [
					self::SECTION_PREFIX . 'enabled' => 'yes',
				],
			]
		);

		$element->end_controls_section();
	}

	/**
	 * @param $element \Elementor\Widget_Base
	 * @param $section_id
	 * @param $args
	 */
	public function register_controls( $element, $args ) {
		$element->add_control(
			self::SECTION_PREFIX . 'conditional_tags_enabled',
			[
				'label'          => __( 'Enable', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SWITCHER,
				'default'        => '',
				'label_on'       => __( 'Yes', 'visibility-logic-elementor-pro' ),
				'label_off'      => __( 'No', 'visibility-logic-elementor-pro' ),
				'return_value'   => 'yes',
				'prefix_class'   => 'stax-conditional_tags_enabled-',
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'conditional_tags_post',
			[
				'label'          => __( 'Post', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SELECT2,
				'options'        => [
					'is_sticky'                 => __( 'Is Sticky', 'visibility-logic-elementor-pro' ),
					'is_post_type_hierarchical' => __( 'Is Hierarchical Post Type', 'visibility-logic-elementor-pro' ),
					'is_post_type_archive'      => __( 'Is Post Type Archive', 'visibility-logic-elementor-pro' ),
					'comments_open'             => __( 'Comments open', 'visibility-logic-elementor-pro' ),
					'pings_open'                => __( 'Pings open', 'visibility-logic-elementor-pro' ),
					'has_tag'                   => __( 'Has Tags', 'visibility-logic-elementor-pro' ),
					'has_term'                  => __( 'Has Terms', 'visibility-logic-elementor-pro' ),
					'has_excerpt'               => __( 'Has Excerpt', 'visibility-logic-elementor-pro' ),
					'has_post_thumbnail'        => __( 'Has Post Thumbnail', 'visibility-logic-elementor-pro' ),
					'has_nav_menu'              => __( 'Has Nav menu', 'visibility-logic-elementor-pro' ),
				],
				'multiple'       => true,
				'label_block'    => true,
				'condition'      => [
					self::SECTION_PREFIX . 'conditional_tags_enabled' => 'yes',
				],
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'conditional_tags_site',
			[
				'label'          => __( 'Site', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SELECT2,
				'options'        => [
					'is_dynamic_sidebar'   => __( 'Dynamic sidebar', 'visibility-logic-elementor-pro' ),
					'is_active_sidebar'    => __( 'Active sidebar', 'visibility-logic-elementor-pro' ),
					'is_rtl'               => __( 'RTL', 'visibility-logic-elementor-pro' ),
					'is_multisite'         => __( 'Multisite', 'visibility-logic-elementor-pro' ),
					'is_main_site'         => __( 'Main site', 'visibility-logic-elementor-pro' ),
					'is_child_theme'       => __( 'Child theme', 'visibility-logic-elementor-pro' ),
					'is_customize_preview' => __( 'Customize preview', 'visibility-logic-elementor-pro' ),
					'is_multi_author'      => __( 'Multi author', 'visibility-logic-elementor-pro' ),
					'is feed'              => __( 'Feed', 'visibility-logic-elementor-pro' ),
					'is_trackback'         => __( 'Trackback', 'visibility-logic-elementor-pro' ),
				],
				'multiple'       => true,
				'label_block'    => true,
				'condition'      => [
					self::SECTION_PREFIX . 'conditional_tags_enabled' => 'yes',
				],
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'conditional_tags_page',
			[
				'label'          => __( 'Page', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SELECT2,
				'options'        => [
					'is_front_page'              => __( 'Front Page', 'visibility-logic-elementor-pro' ),
					'is_home'                    => __( 'Home', 'visibility-logic-elementor-pro' ),
					'is_404'                     => __( '404 Not Found', 'visibility-logic-elementor-pro' ),
					'is_single'                  => __( 'Single', 'visibility-logic-elementor-pro' ),
					'is_page'                    => __( 'Page', 'visibility-logic-elementor-pro' ),
					'is_attachment'              => __( 'Attachment', 'visibility-logic-elementor-pro' ),
					'is_preview'                 => __( 'Preview', 'visibility-logic-elementor-pro' ),
					'is_admin'                   => __( 'Admin', 'visibility-logic-elementor-pro' ),
					'is_page_template'           => __( 'Page Template', 'visibility-logic-elementor-pro' ),
					'is_comments_popup'          => __( 'Comments Popup', 'visibility-logic-elementor-pro' ),
					'is_woocommerce'             => __( 'A Woocommerce Page', 'visibility-logic-elementor-pro' ),
					'is_shop'                    => __( 'Shop', 'visibility-logic-elementor-pro' ),
					'is_product'                 => __( 'Product', 'visibility-logic-elementor-pro' ),
					'is_product_taxonomy'        => __( 'Product Taxonomy', 'visibility-logic-elementor-pro' ),
					'is_product_category'        => __( 'Product Category', 'visibility-logic-elementor-pro' ),
					'is_product_tag'             => __( 'Product Tag', 'visibility-logic-elementor-pro' ),
					'is_cart'                    => __( 'Cart', 'visibility-logic-elementor-pro' ),
					'is_checkout'                => __( 'Checkout', 'visibility-logic-elementor-pro' ),
					'is_add_payment_method_page' => __( 'Add Payment method', 'visibility-logic-elementor-pro' ),
					'is_checkout_pay_page'       => __( 'Checkout Pay', 'visibility-logic-elementor-pro' ),
					'is_account_page'            => __( 'Account page', 'visibility-logic-elementor-pro' ),
					'is_edit_account_page'       => __( 'Edit Account', 'visibility-logic-elementor-pro' ),
					'is_lost_password_page'      => __( 'Lost password', 'visibility-logic-elementor-pro' ),
					'is_view_order_page'         => __( 'Order summary', 'visibility-logic-elementor-pro' ),
					'is_order_received_page'     => __( 'Order complete', 'visibility-logic-elementor-pro' ),
				],
				'multiple'       => true,
				'label_block'    => true,
				'condition'      => [
					self::SECTION_PREFIX . 'conditional_tags_enabled' => 'yes',
				],
				'style_transfer' => false,
			]
		);

		$element->add_control(
			self::SECTION_PREFIX . 'conditional_tags_archive',
			[
				'label'          => __( 'Archive', 'visibility-logic-elementor-pro' ),
				'type'           => Controls_Manager::SELECT2,
				'options'        => [
					'is_blog'       => __( 'Home blog (latest posts)', 'visibility-logic-elementor-pro' ),
					'posts_page'    => __( 'Posts page', 'visibility-logic-elementor-pro' ),
					'is_tax'        => __( 'Taxonomy', 'visibility-logic-elementor-pro' ),
					'is_category'   => __( 'Category', 'visibility-logic-elementor-pro' ),
					'is_tag'        => __( 'Tag', 'visibility-logic-elementor-pro' ),
					'is_author'     => __( 'Author', 'visibility-logic-elementor-pro' ),
					'is_date'       => __( 'Date', 'visibility-logic-elementor-pro' ),
					'is_year'       => __( 'Year', 'visibility-logic-elementor-pro' ),
					'is_month'      => __( 'Month', 'visibility-logic-elementor-pro' ),
					'is_day'        => __( 'Day', 'visibility-logic-elementor-pro' ),
					'is_time'       => __( 'Time', 'visibility-logic-elementor-pro' ),
					'is_new_day'    => __( 'New Day', 'visibility-logic-elementor-pro' ),
					'is_search'     => __( 'Search', 'visibility-logic-elementor-pro' ),
					'is_paged'      => __( 'Paged', 'visibility-logic-elementor-pro' ),
					'is_main_query' => __( 'Main Query', 'visibility-logic-elementor-pro' ),
					'in_the_loop'   => __( 'In the Loop', 'visibility-logic-elementor-pro' ),
				],
				'multiple'       => true,
				'label_block'    => true,
				'condition'      => [
					self::SECTION_PREFIX . 'conditional_tags_enabled' => 'yes',
				],
				'style_transfer' => false,
			]
		);
	}

	/**
	 * Apply conditions
	 *
	 * @param array                   $options
	 * @param array                   $settings
	 * @param \Elementor\Element_Base $item
	 *
	 * @return array
	 */
	public function apply_conditions( $options, $settings, $item ) {
		$settings = $item->get_settings_for_display();

		if ( ! isset( $settings[ self::SECTION_PREFIX . 'conditional_tags_enabled' ] ) ||
			! (bool) $settings[ self::SECTION_PREFIX . 'conditional_tags_enabled' ] ) {
			return $options;
		}

		// Post Conditional.
		if ( ! empty( $settings[ self::SECTION_PREFIX . 'conditional_tags_post' ] ) ) {
			$post_conditional_applied = false;
			$post_type                = get_post_type();

			foreach ( $settings[ self::SECTION_PREFIX . 'conditional_tags_post' ] as $post_conditional ) {
				if ( ! $post_conditional_applied && is_callable( $post_conditional ) ) {
					if ( 'is_post_type_hierarchical' === $post_conditional || 'is_post_type_archive' === $post_conditional ) {
						$post_conditional_applied = call_user_func( $post_conditional, $post_type );
					} elseif ( 'has_post_thumbnail' === $post_conditional ) {
						$post_conditional_applied = call_user_func( $post_conditional, get_the_ID() );
					} elseif ( 'has_nav_menu' === $post_conditional ) {
						$post_conditional_applied = call_user_func( $post_conditional, 'primary' );
					} else {
						$post_conditional_applied = call_user_func( $post_conditional );
					}
				}
			}

			$options['post_conditional_tags'] = $post_conditional_applied;
		}

		// Site Conditional.
		if ( ! empty( $settings[ self::SECTION_PREFIX . 'conditional_tags_site' ] ) ) {
			$site_conditional_applied = false;

			foreach ( $settings[ self::SECTION_PREFIX . 'conditional_tags_site' ] as $site_conditional ) {
				if ( ! $site_conditional_applied && is_callable( $site_conditional ) ) {
					if ( 'is_active_sidebar' === $site_conditional ) {
						$site_conditional_applied = call_user_func( $site_conditional, 'primary' );
					} else {
						$site_conditional_applied = call_user_func( $site_conditional );
					}
				}
			}

			$options['site_conditional_tags'] = $site_conditional_applied;
		}

		// Page Conditional.
		if ( ! empty( $settings[ self::SECTION_PREFIX . 'conditional_tags_page' ] ) ) {
			$page_conditional_applied = false;

			foreach ( $settings[ self::SECTION_PREFIX . 'conditional_tags_page' ] as $page_conditional ) {
				if ( ! $page_conditional_applied ) {
					if ( is_callable( $page_conditional ) ) {
						$page_conditional_applied = call_user_func( $page_conditional );
					}
				}
			}

			$options['page_conditional_tags'] = $page_conditional_applied;
		}

		// Archive Conditional.
		if ( ! empty( $settings[ self::SECTION_PREFIX . 'conditional_tags_archive' ] ) ) {
			$archive_conditional_applied = false;

			$callable = [
				'is_post_type_archive',
				'is_tax',
				'is_taxonomy',
				'is_category',
				'is_tag',
				'is_author',
				'is_date',
				'is_year',
				'is_month',
				'is_day',
				'is_search',
			];

			foreach ( $settings[ self::SECTION_PREFIX . 'conditional_tags_archive' ] as $archive_conditional ) {
				if ( ! $archive_conditional_applied ) {
					if ( in_array( $archive_conditional, $callable ) ) {
						if ( is_callable( $archive_conditional ) ) {
							$archive_conditional_applied = call_user_func( $archive_conditional );
						}
					} else {
						$archive_conditional_applied = is_archive();
					}
				}
			}

			$options['archive_conditional_tags'] = $archive_conditional_applied;
		}

		return $options;
	}

}

ConditionalTagsVisibility::instance();
