<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Wp_Trait {

	/**
	 * Get post types
	 *
	 * @param boolean $exclude
	 * @return array
	 */
	public static function get_post_types( $exclude = true ) {
		$skip_post_types = [ 'attachment', 'elementor_library', 'oceanwp_library' ];
		$post_types      = get_post_types(
			[
				'public' => true,
			]
		);

		if ( $exclude ) {
			$post_types = array_diff( $post_types, $skip_post_types );
		}

		foreach ( $post_types as $akey => $acpt ) {
			$cpt                 = get_post_type_object( $acpt );
			$post_types[ $akey ] = $cpt->label;
		}

		return $post_types;
	}

	/**
	 * Get post fields
	 *
	 * @param boolean $meta
	 * @param boolean $group
	 * @param boolean $info
	 * @return void
	 */
	public static function get_post_fields( $meta = false, $group = false, $info = true ) {
		$post_metas = [];

		if ( $meta ) {
			$post_metas = self::get_post_metas( $group, ( is_string( $meta ) ) ? $meta : null, $info );
		}

		return $post_metas;
	}

	/**
	 * Get post metas
	 *
	 * @param boolean $grouped
	 * @param string  $like
	 * @param boolean $info
	 * @return array
	 */
	public static function get_post_metas( $grouped = false, $like = '', $info = true ) {
		$post_metas         = [];
		$post_metas_grouped = [];

		$cpts = self::get_post_types();

		foreach ( $cpts as $ckey => $cvalue ) {
			$cpt_metas = get_registered_meta_keys( $ckey );
			if ( ! empty( $cpt_metas ) ) {
				foreach ( $cpt_metas as $fkey => $actpmeta ) {
					if ( $like ) {
						$pos_key = stripos( $fkey, $like );
						if ( $pos_key === false ) {
							continue;
						}
					}
					$field_name = $fkey;
					if ( $info ) {
						$field_name .= ' [' . $actpmeta['type'] . ']';
					}
					$post_metas[ $fkey ]                           = $field_name;
					$post_metas_grouped[ 'CPT_' . $ckey ][ $fkey ] = $field_name;
				}
			}
		}

		global $wpdb;
		$query = 'SELECT DISTINCT meta_key FROM ' . $wpdb->prefix . 'postmeta';

		if ( $like ) {
			$query .= " WHERE meta_key LIKE '%" . esc_sql( $like ) . "%'";
		}

		$results = $wpdb->get_results( $query );

		if ( ! empty( $results ) ) {
			$metas = [];

			foreach ( $results as $key => $apost ) {
				$metas[ $apost->meta_key ] = $apost->meta_key;
			}

			ksort( $metas );

			$manual_metas = array_diff_key( $metas, $post_metas );

			foreach ( $manual_metas as $ameta ) {
				if ( substr( $ameta, 0, 8 ) === '_oembed_' ) {
					continue;
				}

				if ( substr( $ameta, 0, 1 ) === '_' ) {
					$tmp = substr( $ameta, 1 );
					if ( in_array( $tmp, $manual_metas ) ) {
						continue;
					}
				}

				if ( ! isset( $post_metas[ $ameta ] ) ) {
					$post_metas[ $ameta ]                   = $ameta;
					$post_metas_grouped['NATIVE'][ $ameta ] = $ameta;
				}
			}
		}

		if ( $grouped ) {
			return $post_metas_grouped;
		}

		return $post_metas;
	}

}
