<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

final class Parser {

	const SHORTOCODE_REGEXP = "/(?P<shortcode>(?:(?:\\s?\\[))(?P<name>[\\w\\-]{3,})(?:\\s(?P<attrs>[\\w\\d,\\s=\\\"\\'\\-\\+\\#\\%\\!\\~\\`\\&\\.\\s\\:\\/\\?\\|]+))?(?:\\])(?:(?P<content>[\\w\\d\\,\\!\\@\\#\\$\\%\\^\\&\\*\\(\\\\)\\s\\=\\\"\\'\\-\\+\\&\\.\\s\\:\\/\\?\\|\\<\\>]+)(?:\\[\\/[\\w\\-\\_]+\\]))?)/u";

	const ATTRIBUTE_REGEXP = "/(?<name>\\S+)=[\"']?(?P<value>(?:.(?![\"']?\\s+(?:\\S+)=|[>\"']))+.)[\"']?/u";

	public static function parse_shortcodes( $text, $single = false ) {
		preg_match_all( self::SHORTOCODE_REGEXP, $text, $matches, PREG_SET_ORDER );

		$shortcodes = [];

		foreach ( $matches as $i => $value ) {
			$shortcodes[ $i ]['shortcode'] = $value['shortcode'];
			$shortcodes[ $i ]['name']      = $value['name'];
			if ( isset( $value['attrs'] ) ) {
				$attrs                     = self::parse_attrs( $value['attrs'] );
				$shortcodes[ $i ]['attrs'] = $attrs;
			}
			if ( isset( $value['content'] ) ) {
				$shortcodes[ $i ]['content'] = $value['content'];
			}
		}

		if ( $single ) {
			return isset( $shortcodes[0] ) ? $shortcodes[0] : false;
		}

		return $shortcodes;
	}

	private static function parse_attrs( $attrs ) {
		preg_match_all( self::ATTRIBUTE_REGEXP, $attrs, $matches, PREG_SET_ORDER );

		$attributes = [];

		foreach ( $matches as $i => $value ) {
			$key                      = $value['name'];
			$attributes[ $i ][ $key ] = $value['value'];
		}
		return $attributes;
	}

}
