<h2 class="ste-my-0 ste-leading-none ste-text-2xl ste-text-gray-900 ste-font-bold ste-tracking-wide">
	<?php esc_html_e( 'Settings', 'visibility-logic-elementor-pro' ); ?>
</h2>

<div class="ste-text-sm ste-text-gray-700 ste-mt-2">
	<?php esc_html_e( 'Some Visibility options need specific settings. Make sure you provide all the needed settings here in order for them to work correctly.', 'visibility-logic-elementor-pro' ); ?>
</div>

<div class="ste-mt-5">
	<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="POST">
		<div class="ste-grid ste-grid-cols-1 md:ste-grid-cols-2 lg:ste-grid-cols-3 ste-gap-4">
			<div>
				<h3 class="ste-mt-0 ste-mb-4"><?php esc_html_e( 'MaxMind Api', 'visibility-logic-elementor-pro' ); ?></h3>
				
				<div class="ste-mb-2">
					<label class="ste-block ste-mb-1"><?php esc_html_e( 'Account ID', 'visibility-logic-elementor-pro' ); ?></label>
					<input type="text" name="maxmind_account_id" value="<?php echo esc_attr( $maxmind['account_id'] ); ?>" class="ste-p-2 ste-w-full ste-border-gray-300">
				</div>

				<div>
					<label class="ste-block ste-mb-1"><?php esc_html_e( 'License key', 'visibility-logic-elementor-pro' ); ?></label>
					<input type="password" name="maxmind_license_key" value="<?php echo esc_attr( $maxmind['license_key'] ); ?>" class="ste-p-2 ste-w-full ste-border-gray-300">
				</div>
			</div>
		</div>
		<input type="hidden" name="action" value="stax_visibility_settings">

		<div class="ste-mt-5">
			<button type="submit"
					class="ste-bg-gradient-to-r ste-from-green-500 ste-to-green-400 ste-text-md ste-text-white ste-py-3 ste-px-6 ste-rounded ste-border-0 ste-shadow-xl hover:ste-shadow-lg ste-cursor-pointer">
				<span class="ste-flex ste-items-center">
					<svg class="ste-fill-current" xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>
					<span class="ste-leading-none ste-font-bold ste-ml-2 ste-uppercase"><?php esc_html_e( 'Save', 'visibility-logic-elementor-pro' ); ?></span>
				</span>
			</button>
		</div>
	</form>
</div>
