<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class OptionSettings extends \Stax\VisibilityLogic\Base {

	/**
	 * Settings constructor.
	 */
	public function __construct() {
		$this->current_slug = 'settings';

		if ( \Stax\VisibilityLogic\Resources::is_current_page( $this->current_slug ) ) {
			add_filter( STAX_VISIBILITY_HOOK_PREFIX . 'current_slug', [ $this, 'set_page_slug' ] );
			add_filter( STAX_VISIBILITY_HOOK_PREFIX . 'welcome_wrapper_class', [ $this, 'set_wrapper_classes' ] );
			add_action( STAX_VISIBILITY_HOOK_PREFIX . $this->current_slug . '_page_content', [ $this, 'panel_content' ] );
		}

		add_filter( STAX_VISIBILITY_HOOK_PREFIX . 'admin_menu', [ $this, 'add_menu_item' ] );
		add_action( 'admin_post_stax_visibility_settings', [ $this, 'save_settings' ] );
	}

	/**
	 * Save settings
	 *
	 * @return void
	 */
	public function save_settings() {
		if ( ! isset( $_POST['action'] ) || 'stax_visibility_settings' !== $_POST['action'] ) {
			wp_redirect( admin_url( 'options-general.php?page=' . STAX_VISIBILITY_SLUG_PREFIX . $this->current_slug ) );
		}

		$settings = get_option( 'stax_visibility_settings', [] );

		if ( isset( $_POST['maxmind_account_id'] ) && isset( $_POST['maxmind_license_key'] ) ) {
			update_option(
				'stax_visibility_settings',
				array_merge(
					$settings,
					[
						'maxmind_account_id'  => sanitize_text_field( $_POST['maxmind_account_id'] ),
						'maxmind_license_key' => sanitize_text_field( $_POST['maxmind_license_key'] ),
					]
				)
			);
		}

		wp_redirect( admin_url( 'options-general.php?page=' . STAX_VISIBILITY_SLUG_PREFIX . $this->current_slug ) );
		exit();
	}

	/**
	 * Panel content
	 */
	public function panel_content() {
		$settings = get_option( 'stax_visibility_settings', [] );

		Template::load(
			'core/admin/pages/templates/settings',
			[
				'maxmind' => [
					'account_id'  => isset( $settings['maxmind_account_id'] ) ? $settings['maxmind_account_id'] : '',
					'license_key' => isset( $settings['maxmind_license_key'] ) ? $settings['maxmind_license_key'] : '',
				],
			]
		);
	}

	/**
	 * Add menu item
	 *
	 * @param array $menu
	 * @return array
	 */
	public function add_menu_item( $menu ) {
		$menu[] = [
			'name'     => __( 'Settings', 'visibility-logic-elementor-pro' ),
			'link'     => admin_url( 'options-general.php?page=' . STAX_VISIBILITY_SLUG_PREFIX . $this->current_slug ),
			'query'    => STAX_VISIBILITY_SLUG_PREFIX . $this->current_slug,
			'priority' => 3,
		];

		return $menu;
	}

}

OptionSettings::instance();
