<?php

namespace Stax\VisibilityLogicPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Settings {

	/**
	 * @var null
	 */
	public static $instance;

	/**
	 * @return Settings|null
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Settings constructor.
	 */
	public function __construct() {
		add_action( 'admin_menu', [ $this, 'register_menu' ], 10 );
	}

	/**
	 * Register admin menu
	 */
	public function register_menu() {
		add_submenu_page(
			'options-general.php',
			__( 'STAX Visibility - Settings', 'visibility-logic-elementor-pro' ),
			__( 'Visibility Logic Settings', 'visibility-logic-elementor-pro' ),
			'manage_options',
			'stax-visibility-settings',
			[ \Stax\VisibilityLogic\Settings::instance(), 'settings_template' ]
		);

		remove_submenu_page('options-general.php', 'stax-visibility-settings');
	}
}

Settings::instance();
