<?php
/**
 * Plugin Name: Visibility Logic PRO for Elementor
 * Description: Hide or show Elementor widgets based on conditions
 * Plugin URI: https://staxwp.com/go/visibility-logic
 * Author URI: https://staxwp.com
 * Author: StaxWP
 * Version: 2.3.2
 *
 * Elementor tested up to: 3.6.7
 * Elementor Pro tested up to: 3.7.2
 *
 * Text Domain: visibility-logic-elementor-pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'STAX_VISIBILITY_PRO_VERSION', '2.3.2' );

define( 'STAX_VISIBILITY_PRO_FILE', __FILE__ );
define( 'STAX_VISIBILITY_PRO_PLUGIN_BASE', plugin_basename( STAX_VISIBILITY_PRO_FILE ) );
define( 'STAX_VISIBILITY_PRO_PATH', plugin_dir_path( STAX_VISIBILITY_PRO_FILE ) );
define( 'STAX_VISIBILITY_PRO_BASE_URL', plugins_url( '/', STAX_VISIBILITY_PRO_FILE ) );
define( 'STAX_VISIBILITY_PRO_CORE_PATH', STAX_VISIBILITY_PRO_PATH . 'core/' );
define( 'STAX_VISIBILITY_PRO_CORE_SETTINGS_PATH', STAX_VISIBILITY_PRO_CORE_PATH . 'settings/' );

define( 'STAX_VISIBILITY_PRO_HOOK_PREFIX', 'stax_visibility_' );
define( 'STAX_VISIBILITY_PRO_SLUG_PREFIX', 'stax-visibility-' );

// Load plugin.
require __DIR__ . '/vendor/autoload.php';
require_once STAX_VISIBILITY_PRO_CORE_PATH . 'Singleton.php';
require_once STAX_VISIBILITY_PRO_CORE_PATH . 'Plugin.php';


add_action( 'plugins_loaded', 'stax_vle_pro_load_textdomain' );

/**
 * Load textdomain.
 *
 * Load gettext translate for Elementor text domain.
 *
 * @return void
 * @since 1.0.0
 */
function stax_vle_pro_load_textdomain() {
	load_plugin_textdomain( 'visibility-logic-elementor-pro' );
}
