window.addEventListener('elementor/init', () => {

    elementor.hooks.addFilter('elements/context-menu/groups', (customGroups, elementType) => {
        const staxVisibilityGroup = {
            name: 'stax-visibility-group',
            actions: [],
        }

        if ('widget' === elementType || 'section' === elementType || 'container' === elementType) {
            customGroups.push(staxVisibilityGroup);
        }

        return customGroups;
    });

    function validateControls(source, target) {
        let result = true;

        // Cannot use `_.isEmpty()` does not pass paste style test.
        if (
            null === source ||
            null === target ||
            undefined === source ||
            undefined === target ||
            ('object' === typeof source ^ 'object' === typeof target)
        ) {
            result = false;
        }

        return result;
    }

    const elTypes = ['widget', 'container', 'section'];

    elTypes.forEach((elType) => {
        elementor.hooks.addFilter(`elements/${elType}/contextMenuGroups`, (groups, view) => {
            groups.forEach((group) => {
                if ('stax-visibility-group' === group.name) {
                    group.actions.push({
                        name: 'stax-visibility-copy',
                        icon: '',
                        title: 'Copy Visibility Settings',
                        isEnabled: () => true,
                        callback: function () {
                            var data = {};
                            var targetContainer = view.container;
                            var attributes = targetContainer.settings.attributes;

                            data.elType = targetContainer.type;
                            data.elSettings = Object.keys(attributes).filter((key) => key.includes('stax_visibility')).
                                reduce((cur, key) => { return Object.assign(cur, { [key]: attributes[key] }) }, {});;

                            localStorage.setItem('staxVisibility', JSON.stringify(data), function () {
                                elementor.notifications.showToast({
                                    message: elementor.translate('Visibility Copied')
                                });
                            });
                        },
                    });

                    group.actions.push({
                        name: 'stax-visibility-paste',
                        icon: '',
                        title: 'Paste Visibility Settings',
                        isEnabled: () => localStorage.getItem('staxVisibility') !== null,
                        callback: function () {
                            const data = JSON.parse(localStorage.getItem('staxVisibility'));
                            var targetContainer = view.container;

                            if (targetContainer.type !== data.elType) {
                                return;
                            }

                            $e.run('document/elements/settings', {
                                container: targetContainer,
                                settings: data.elSettings,
                                options: {
                                    external: true,
                                    render: false
                                }
                            });

                            targetContainer.render();

                            elementor.notifications.showToast({
                                message: elementor.translate('Visibility Pasted')
                            });
                        },
                    });
                }
            });

            return groups;
        });
    });

});