<?php
/**
 *  Commonly used constants
 *
 * @link       https://searchandfilter.com
 * @since      3.0.0
 *
 * @package    Search_Filter
 */

if ( ! defined( 'SEARCH_FILTER_SLUG' ) ) {
	define( 'SEARCH_FILTER_SLUG', 'search-filter' );
}

if ( ! defined( 'SEARCH_FILTER_VERSION' ) ) {
	define( 'SEARCH_FILTER_VERSION', '3.1.6' );
}

if ( ! defined( 'SEARCH_FILTER_URL' ) ) {
	define( 'SEARCH_FILTER_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'SEARCH_FILTER_PATH' ) ) {
	define( 'SEARCH_FILTER_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'SEARCH_FILTER_QUERY_DEBUG' ) ) {
	define( 'SEARCH_FILTER_QUERY_DEBUG', false );
}

// Define exception codes.

define( 'SEARCH_FILTER_EXCEPTION_SETTING_INVALID_NAME', 1 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_MISSING_ARGUMENTS', 2 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_NOT_READY', 3 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_INVALID_SECTION', 4 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_EXISTS', 5 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_NOT_EXIST', 6 );

define( 'SEARCH_FILTER_EXCEPTION_FIELD_NOT_READY', 101 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_INVALID_TYPE', 102 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_INVALID_INPUT_TYPE', 103 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_EXISTS', 104 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NOT_EXISTS', 105 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NOT_REGISTERED', 106 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_CLASS_MISSING', 107 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NO_RENDER_METHOD', 108 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NO_CREATE_METHOD', 109 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_CLASS_NOT_REGISTERED', 110 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NO_TYPE', 111 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NO_INPUT_TYPE', 112 );
define( 'SEARCH_FILTER_EXCEPTION_FIELD_NOT_INIT', 109 );

define( 'SEARCH_FILTER_EXCEPTION_QUERY_NOT_EXISTS', 205 );
define( 'SEARCH_FILTER_EXCEPTION_QUERY_NOT_INIT', 206 );

define( 'SEARCH_FILTER_EXCEPTION_RECORD_NOT_EXISTS', 405 );

define( 'SEARCH_FILTER_EXCEPTION_SETTING_TOO_EARLY', 501 );
define( 'SEARCH_FILTER_EXCEPTION_SECTION_REGISTERED', 502 );
define( 'SEARCH_FILTER_EXCEPTION_BAD_FIND_CONDITIONS', 503 );

define( 'SEARCH_FILTER_EXCEPTION_SETTING_INVALID_CONDITIONS', 600 );
define( 'SEARCH_FILTER_EXCEPTION_SETTING_INVALID_OPTION', 601 );
define( 'SEARCH_FILTER_EXCEPTION_SETTINGS_REGISTERY_EXISTS', 602 );


$env_path = plugin_dir_path( __FILE__ ) . 'env.php';
if ( file_exists( $env_path ) ) {
	require_once $env_path;
}
