<?php
/**
 * Index Table Class.
 *
 * @since 3.0.0
 *
 * @package Search_Filter_Pro\Indexer\Database
 */

namespace Search_Filter_Pro\Indexer\Cache;

use Search_Filter\Core\Data_Store;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Index Table Class.
 *
 * @since 3.0.0
 */
class Table extends \Search_Filter\Database\Engine\Table {

	/**
	 * Table name, without the global table prefix.
	 *
	 * @since 1.0.0
	 * @var   string
	 */
	public $name = 'index_cache';

	/**
	 * Database version key (saved in _options or _sitemeta)
	 *
	 * @since 1.0.0
	 * @var   string
	 */
	protected $db_version_key = 'search_filter_pro_index_cache_table_version';

	/**
	 * Optional description.
	 *
	 * @since 1.0.0
	 * @var   string
	 */
	public $description = 'Index Cache';

	/**
	 * Database version.
	 *
	 * @since 1.0.0
	 * @var   mixed
	 */
	protected $version = '3.0.0';

	/**
	 * Key => value array of versions => methods.
	 *
	 * @since 3.0.0
	 * @var   array
	 */
	protected $upgrades = array();

	/**
	 * Setup this database table.
	 *
	 * @since 3.0.0
	 */
	protected function set_schema() {
		$this->schema = "
			id                    bigint(20)  unsigned NOT NULL AUTO_INCREMENT,
			query_id              bigint(20)  unsigned NOT NULL default '0',
			field_id              bigint(20)  unsigned NOT NULL default '0',
			type                  varchar(20)          NOT NULL default '',
			cache_key             text                 NOT NULL default '',
			cache_value           longtext             NOT NULL default '',
			date_modified         datetime             NOT NULL default CURRENT_TIMESTAMP,
			expires               bigint(20)  unsigned NOT NULL default 0,
			PRIMARY KEY (id),
			KEY query_id (query_id),
			KEY field_id (field_id),
			KEY type (type),
			KEY cache_key (cache_key(768))
			";
	}

	/**
	 * Drop the table.
	 *
	 * Also clear the data_store cache when the table is dropped.
	 *
	 * @since 3.0.0
	 */
	public function drop() {
		// Drop the table.
		parent::drop();

		Data_Store::flush( 'index_cache' );
	}
}
