<?php

namespace WordpressModelsPlugin\DependencyInjection;

use WordpressModels\Traits\SingletonTrait;
use WordpressModelsPlugin\DependencyInjection\FederatedPages\FederatedPagesExtension;

class ContainerExtensions
{

    use SingletonTrait;

    private FederatedPagesExtension $federatedPagesExtension;

    private function __construct()
    {
        $this->federatedPagesExtension = new FederatedPagesExtension();

        add_filter('container_compiler_passes', [$this, 'addCompilerPasses']);
        add_filter('container_extensions', [$this, 'addExtensions']);
    }

    public function addCompilerPasses(array $compilerPasses): array
    {
        $compilerPasses[] = $this->federatedPagesExtension;

        return $compilerPasses;
    }

    public function addExtensions(array $extensions): array
    {
        $extensions[] = $this->federatedPagesExtension;

        return $extensions;
    }


}