<?php

use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\HttpFoundation\Request;
use WordpressModels\Assets;

return static function (ContainerConfigurator $container) {
    $services = $container->services();

    $services->set('request', Request::class)
        ->factory([Request::class, 'createFromGlobals']);
    $services->alias(Request::class, 'request');

    $services->set('assets.wordpress-models-plugin', Assets::class)
        ->args([WPM_PLUGIN_DIR . '/build', WPM_PLUGIN_URL . '/build']);
};